package zio.aws.redshiftserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class TableRestoreStatus(
    message: Optional[String] = Optional.Absent,
    namespaceName: Optional[String] = Optional.Absent,
    newTableName: Optional[String] = Optional.Absent,
    progressInMegaBytes: Optional[Long] = Optional.Absent,
    requestTime: Optional[Timestamp] = Optional.Absent,
    snapshotName: Optional[String] = Optional.Absent,
    sourceDatabaseName: Optional[String] = Optional.Absent,
    sourceSchemaName: Optional[String] = Optional.Absent,
    sourceTableName: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    tableRestoreRequestId: Optional[String] = Optional.Absent,
    targetDatabaseName: Optional[String] = Optional.Absent,
    targetSchemaName: Optional[String] = Optional.Absent,
    totalDataInMegaBytes: Optional[Long] = Optional.Absent,
    workgroupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.TableRestoreStatus = {
    import TableRestoreStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.TableRestoreStatus
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(namespaceName.map(value => value: java.lang.String))(
        _.namespaceName
      )
      .optionallyWith(newTableName.map(value => value: java.lang.String))(
        _.newTableName
      )
      .optionallyWith(progressInMegaBytes.map(value => value: java.lang.Long))(
        _.progressInMegaBytes
      )
      .optionallyWith(
        requestTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.requestTime)
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(sourceDatabaseName.map(value => value: java.lang.String))(
        _.sourceDatabaseName
      )
      .optionallyWith(sourceSchemaName.map(value => value: java.lang.String))(
        _.sourceSchemaName
      )
      .optionallyWith(sourceTableName.map(value => value: java.lang.String))(
        _.sourceTableName
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        tableRestoreRequestId.map(value => value: java.lang.String)
      )(_.tableRestoreRequestId)
      .optionallyWith(targetDatabaseName.map(value => value: java.lang.String))(
        _.targetDatabaseName
      )
      .optionallyWith(targetSchemaName.map(value => value: java.lang.String))(
        _.targetSchemaName
      )
      .optionallyWith(totalDataInMegaBytes.map(value => value: java.lang.Long))(
        _.totalDataInMegaBytes
      )
      .optionallyWith(workgroupName.map(value => value: java.lang.String))(
        _.workgroupName
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly =
    zio.aws.redshiftserverless.model.TableRestoreStatus.wrap(buildAwsValue())
}
object TableRestoreStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.TableRestoreStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.TableRestoreStatus =
      zio.aws.redshiftserverless.model.TableRestoreStatus(
        message.map(value => value),
        namespaceName.map(value => value),
        newTableName.map(value => value),
        progressInMegaBytes.map(value => value),
        requestTime.map(value => value),
        snapshotName.map(value => value),
        sourceDatabaseName.map(value => value),
        sourceSchemaName.map(value => value),
        sourceTableName.map(value => value),
        status.map(value => value),
        tableRestoreRequestId.map(value => value),
        targetDatabaseName.map(value => value),
        targetSchemaName.map(value => value),
        totalDataInMegaBytes.map(value => value),
        workgroupName.map(value => value)
      )
    def message: Optional[String]
    def namespaceName: Optional[String]
    def newTableName: Optional[String]
    def progressInMegaBytes: Optional[Long]
    def requestTime: Optional[Timestamp]
    def snapshotName: Optional[String]
    def sourceDatabaseName: Optional[String]
    def sourceSchemaName: Optional[String]
    def sourceTableName: Optional[String]
    def status: Optional[String]
    def tableRestoreRequestId: Optional[String]
    def targetDatabaseName: Optional[String]
    def targetSchemaName: Optional[String]
    def totalDataInMegaBytes: Optional[Long]
    def workgroupName: Optional[String]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getNamespaceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
    def getNewTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("newTableName", newTableName)
    def getProgressInMegaBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("progressInMegaBytes", progressInMegaBytes)
    def getRequestTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("requestTime", requestTime)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getSourceDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceDatabaseName", sourceDatabaseName)
    def getSourceSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceSchemaName", sourceSchemaName)
    def getSourceTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceTableName", sourceTableName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getTableRestoreRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableRestoreRequestId", tableRestoreRequestId)
    def getTargetDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetDatabaseName", targetDatabaseName)
    def getTargetSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetSchemaName", targetSchemaName)
    def getTotalDataInMegaBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalDataInMegaBytes", totalDataInMegaBytes)
    def getWorkgroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workgroupName", workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.TableRestoreStatus
  ) extends zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly {
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val namespaceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceName())
      .map(value => value: String)
    override val newTableName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.newTableName())
      .map(value => value: String)
    override val progressInMegaBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.progressInMegaBytes())
      .map(value => value: Long)
    override val requestTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.requestTime())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.Timestamp(value)
      )
    override val snapshotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotName())
      .map(value => value: String)
    override val sourceDatabaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDatabaseName())
      .map(value => value: String)
    override val sourceSchemaName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceSchemaName())
      .map(value => value: String)
    override val sourceTableName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceTableName())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val tableRestoreRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableRestoreRequestId())
      .map(value => value: String)
    override val targetDatabaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetDatabaseName())
      .map(value => value: String)
    override val targetSchemaName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetSchemaName())
      .map(value => value: String)
    override val totalDataInMegaBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalDataInMegaBytes())
      .map(value => value: Long)
    override val workgroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workgroupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.TableRestoreStatus
  ): zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly = new Wrapper(
    impl
  )
}
