package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreTableFromSnapshotRequest(
    activateCaseSensitiveIdentifier: Optional[Boolean] = Optional.Absent,
    namespaceName: String,
    newTableName: String,
    snapshotName: String,
    sourceDatabaseName: String,
    sourceSchemaName: Optional[String] = Optional.Absent,
    sourceTableName: String,
    targetDatabaseName: Optional[String] = Optional.Absent,
    targetSchemaName: Optional[String] = Optional.Absent,
    workgroupName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotRequest = {
    import RestoreTableFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotRequest
      .builder()
      .optionallyWith(
        activateCaseSensitiveIdentifier.map(value => value: java.lang.Boolean)
      )(_.activateCaseSensitiveIdentifier)
      .namespaceName(namespaceName: java.lang.String)
      .newTableName(newTableName: java.lang.String)
      .snapshotName(snapshotName: java.lang.String)
      .sourceDatabaseName(sourceDatabaseName: java.lang.String)
      .optionallyWith(sourceSchemaName.map(value => value: java.lang.String))(
        _.sourceSchemaName
      )
      .sourceTableName(sourceTableName: java.lang.String)
      .optionallyWith(targetDatabaseName.map(value => value: java.lang.String))(
        _.targetDatabaseName
      )
      .optionallyWith(targetSchemaName.map(value => value: java.lang.String))(
        _.targetSchemaName
      )
      .workgroupName(workgroupName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.RestoreTableFromSnapshotRequest.ReadOnly =
    zio.aws.redshiftserverless.model.RestoreTableFromSnapshotRequest
      .wrap(buildAwsValue())
}
object RestoreTableFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.RestoreTableFromSnapshotRequest =
      zio.aws.redshiftserverless.model.RestoreTableFromSnapshotRequest(
        activateCaseSensitiveIdentifier.map(value => value),
        namespaceName,
        newTableName,
        snapshotName,
        sourceDatabaseName,
        sourceSchemaName.map(value => value),
        sourceTableName,
        targetDatabaseName.map(value => value),
        targetSchemaName.map(value => value),
        workgroupName
      )
    def activateCaseSensitiveIdentifier: Optional[Boolean]
    def namespaceName: String
    def newTableName: String
    def snapshotName: String
    def sourceDatabaseName: String
    def sourceSchemaName: Optional[String]
    def sourceTableName: String
    def targetDatabaseName: Optional[String]
    def targetSchemaName: Optional[String]
    def workgroupName: String
    def getActivateCaseSensitiveIdentifier: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "activateCaseSensitiveIdentifier",
        activateCaseSensitiveIdentifier
      )
    def getNamespaceName: ZIO[Any, Nothing, String] = ZIO.succeed(namespaceName)
    def getNewTableName: ZIO[Any, Nothing, String] = ZIO.succeed(newTableName)
    def getSnapshotName: ZIO[Any, Nothing, String] = ZIO.succeed(snapshotName)
    def getSourceDatabaseName: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDatabaseName)
    def getSourceSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceSchemaName", sourceSchemaName)
    def getSourceTableName: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceTableName)
    def getTargetDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetDatabaseName", targetDatabaseName)
    def getTargetSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetSchemaName", targetSchemaName)
    def getWorkgroupName: ZIO[Any, Nothing, String] = ZIO.succeed(workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotRequest
  ) extends zio.aws.redshiftserverless.model.RestoreTableFromSnapshotRequest.ReadOnly {
    override val activateCaseSensitiveIdentifier: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activateCaseSensitiveIdentifier())
        .map(value => value: Boolean)
    override val namespaceName: String = impl.namespaceName(): String
    override val newTableName: String = impl.newTableName(): String
    override val snapshotName: String = impl.snapshotName(): String
    override val sourceDatabaseName: String = impl.sourceDatabaseName(): String
    override val sourceSchemaName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceSchemaName())
      .map(value => value: String)
    override val sourceTableName: String = impl.sourceTableName(): String
    override val targetDatabaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetDatabaseName())
      .map(value => value: String)
    override val targetSchemaName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetSchemaName())
      .map(value => value: String)
    override val workgroupName: String = impl.workgroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RestoreTableFromSnapshotRequest
  ): zio.aws.redshiftserverless.model.RestoreTableFromSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
