package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyRequest(policy: String, resourceArn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyRequest
      .builder()
      .policy(policy: java.lang.String)
      .resourceArn(resourceArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.redshiftserverless.model.PutResourcePolicyRequest
      .wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.PutResourcePolicyRequest =
      zio.aws.redshiftserverless.model
        .PutResourcePolicyRequest(policy, resourceArn)
    def policy: String
    def resourceArn: String
    def getPolicy: ZIO[Any, Nothing, String] = ZIO.succeed(policy)
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyRequest
  ) extends zio.aws.redshiftserverless.model.PutResourcePolicyRequest.ReadOnly {
    override val policy: String = impl.policy(): String
    override val resourceArn: String = impl.resourceArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyRequest
  ): zio.aws.redshiftserverless.model.PutResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
