package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.PaginationToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTableRestoreStatusResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    tableRestoreStatuses: Optional[
      Iterable[zio.aws.redshiftserverless.model.TableRestoreStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse = {
    import ListTableRestoreStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        tableRestoreStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tableRestoreStatuses)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListTableRestoreStatusResponse.ReadOnly =
    zio.aws.redshiftserverless.model.ListTableRestoreStatusResponse
      .wrap(buildAwsValue())
}
object ListTableRestoreStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.ListTableRestoreStatusResponse =
      zio.aws.redshiftserverless.model.ListTableRestoreStatusResponse(
        nextToken.map(value => value),
        tableRestoreStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def tableRestoreStatuses: Optional[
      List[zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTableRestoreStatuses: ZIO[Any, AwsError, List[
      zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly
    ]] =
      AwsError.unwrapOptionField("tableRestoreStatuses", tableRestoreStatuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse
  ) extends zio.aws.redshiftserverless.model.ListTableRestoreStatusResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.PaginationToken(value)
      )
    override val tableRestoreStatuses: Optional[
      List[zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tableRestoreStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftserverless.model.TableRestoreStatus.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusResponse
  ): zio.aws.redshiftserverless.model.ListTableRestoreStatusResponse.ReadOnly =
    new Wrapper(impl)
}
