package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTableRestoreStatusResponse(
    tableRestoreStatus: Optional[
      zio.aws.redshiftserverless.model.TableRestoreStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusResponse = {
    import GetTableRestoreStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusResponse
      .builder()
      .optionallyWith(tableRestoreStatus.map(value => value.buildAwsValue()))(
        _.tableRestoreStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.GetTableRestoreStatusResponse.ReadOnly =
    zio.aws.redshiftserverless.model.GetTableRestoreStatusResponse
      .wrap(buildAwsValue())
}
object GetTableRestoreStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.GetTableRestoreStatusResponse =
      zio.aws.redshiftserverless.model.GetTableRestoreStatusResponse(
        tableRestoreStatus.map(value => value.asEditable)
      )
    def tableRestoreStatus
        : Optional[zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly]
    def getTableRestoreStatus: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly
    ] = AwsError.unwrapOptionField("tableRestoreStatus", tableRestoreStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusResponse
  ) extends zio.aws.redshiftserverless.model.GetTableRestoreStatusResponse.ReadOnly {
    override val tableRestoreStatus: Optional[
      zio.aws.redshiftserverless.model.TableRestoreStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tableRestoreStatus())
      .map(value =>
        zio.aws.redshiftserverless.model.TableRestoreStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetTableRestoreStatusResponse
  ): zio.aws.redshiftserverless.model.GetTableRestoreStatusResponse.ReadOnly =
    new Wrapper(impl)
}
