package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.redshiftserverless.model.primitives.NamespaceName
import scala.jdk.CollectionConverters._
final case class GetNamespaceRequest(namespaceName: NamespaceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceRequest = {
    import GetNamespaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceRequest
      .builder()
      .namespaceName(NamespaceName.unwrap(namespaceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.GetNamespaceRequest.ReadOnly =
    zio.aws.redshiftserverless.model.GetNamespaceRequest.wrap(buildAwsValue())
}
object GetNamespaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.GetNamespaceRequest =
      zio.aws.redshiftserverless.model.GetNamespaceRequest(namespaceName)
    def namespaceName: NamespaceName
    def getNamespaceName: ZIO[Any, Nothing, NamespaceName] =
      ZIO.succeed(namespaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceRequest
  ) extends zio.aws.redshiftserverless.model.GetNamespaceRequest.ReadOnly {
    override val namespaceName: NamespaceName =
      zio.aws.redshiftserverless.model.primitives
        .NamespaceName(impl.namespaceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetNamespaceRequest
  ): zio.aws.redshiftserverless.model.GetNamespaceRequest.ReadOnly =
    new Wrapper(impl)
}
