package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.{
  WorkgroupName,
  Integer,
  DbName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCredentialsRequest(
    dbName: Optional[DbName] = Optional.Absent,
    durationSeconds: Optional[Integer] = Optional.Absent,
    workgroupName: WorkgroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest = {
    import GetCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest
      .builder()
      .optionallyWith(
        dbName.map(value => DbName.unwrap(value): java.lang.String)
      )(_.dbName)
      .optionallyWith(durationSeconds.map(value => value: java.lang.Integer))(
        _.durationSeconds
      )
      .workgroupName(WorkgroupName.unwrap(workgroupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.GetCredentialsRequest.ReadOnly =
    zio.aws.redshiftserverless.model.GetCredentialsRequest.wrap(buildAwsValue())
}
object GetCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.GetCredentialsRequest =
      zio.aws.redshiftserverless.model.GetCredentialsRequest(
        dbName.map(value => value),
        durationSeconds.map(value => value),
        workgroupName
      )
    def dbName: Optional[DbName]
    def durationSeconds: Optional[Integer]
    def workgroupName: WorkgroupName
    def getDbName: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getDurationSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getWorkgroupName: ZIO[Any, Nothing, WorkgroupName] =
      ZIO.succeed(workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest
  ) extends zio.aws.redshiftserverless.model.GetCredentialsRequest.ReadOnly {
    override val dbName: Optional[DbName] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => zio.aws.redshiftserverless.model.primitives.DbName(value))
    override val durationSeconds: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.durationSeconds())
      .map(value => value: Integer)
    override val workgroupName: WorkgroupName =
      zio.aws.redshiftserverless.model.primitives
        .WorkgroupName(impl.workgroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest
  ): zio.aws.redshiftserverless.model.GetCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
