package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Endpoint(
    address: Optional[String] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    vpcEndpoints: Optional[
      Iterable[zio.aws.redshiftserverless.model.VpcEndpoint]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.Endpoint = {
    import Endpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.Endpoint
      .builder()
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        vpcEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcEndpoints)
      .build()
  }
  def asReadOnly: zio.aws.redshiftserverless.model.Endpoint.ReadOnly =
    zio.aws.redshiftserverless.model.Endpoint.wrap(buildAwsValue())
}
object Endpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.Endpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.Endpoint =
      zio.aws.redshiftserverless.model.Endpoint(
        address.map(value => value),
        port.map(value => value),
        vpcEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def address: Optional[String]
    def port: Optional[Integer]
    def vpcEndpoints
        : Optional[List[zio.aws.redshiftserverless.model.VpcEndpoint.ReadOnly]]
    def getAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("address", address)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getVpcEndpoints: ZIO[Any, AwsError, List[
      zio.aws.redshiftserverless.model.VpcEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcEndpoints", vpcEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.Endpoint
  ) extends zio.aws.redshiftserverless.model.Endpoint.ReadOnly {
    override val address: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value => value: String)
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val vpcEndpoints: Optional[
      List[zio.aws.redshiftserverless.model.VpcEndpoint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftserverless.model.VpcEndpoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.Endpoint
  ): zio.aws.redshiftserverless.model.Endpoint.ReadOnly = new Wrapper(impl)
}
