package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateWorkgroupResponse(
    workgroup: Optional[zio.aws.redshiftserverless.model.Workgroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupResponse = {
    import CreateWorkgroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupResponse
      .builder()
      .optionallyWith(workgroup.map(value => value.buildAwsValue()))(
        _.workgroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.CreateWorkgroupResponse.ReadOnly =
    zio.aws.redshiftserverless.model.CreateWorkgroupResponse
      .wrap(buildAwsValue())
}
object CreateWorkgroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.CreateWorkgroupResponse =
      zio.aws.redshiftserverless.model
        .CreateWorkgroupResponse(workgroup.map(value => value.asEditable))
    def workgroup: Optional[zio.aws.redshiftserverless.model.Workgroup.ReadOnly]
    def getWorkgroup: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.Workgroup.ReadOnly
    ] = AwsError.unwrapOptionField("workgroup", workgroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupResponse
  ) extends zio.aws.redshiftserverless.model.CreateWorkgroupResponse.ReadOnly {
    override val workgroup
        : Optional[zio.aws.redshiftserverless.model.Workgroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workgroup())
        .map(value => zio.aws.redshiftserverless.model.Workgroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupResponse
  ): zio.aws.redshiftserverless.model.CreateWorkgroupResponse.ReadOnly =
    new Wrapper(impl)
}
