package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.{
  SubnetId,
  SecurityGroupId,
  WorkgroupName,
  NamespaceName,
  Integer
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateWorkgroupRequest(
    baseCapacity: Optional[Integer] = Optional.Absent,
    configParameters: Optional[
      Iterable[zio.aws.redshiftserverless.model.ConfigParameter]
    ] = Optional.Absent,
    enhancedVpcRouting: Optional[Boolean] = Optional.Absent,
    namespaceName: NamespaceName,
    port: Optional[Integer] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshiftserverless.model.Tag]] =
      Optional.Absent,
    workgroupName: WorkgroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupRequest = {
    import CreateWorkgroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupRequest
      .builder()
      .optionallyWith(baseCapacity.map(value => value: java.lang.Integer))(
        _.baseCapacity
      )
      .optionallyWith(
        configParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configParameters)
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .namespaceName(NamespaceName.unwrap(namespaceName): java.lang.String)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .workgroupName(WorkgroupName.unwrap(workgroupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.CreateWorkgroupRequest.ReadOnly =
    zio.aws.redshiftserverless.model.CreateWorkgroupRequest
      .wrap(buildAwsValue())
}
object CreateWorkgroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.CreateWorkgroupRequest =
      zio.aws.redshiftserverless.model.CreateWorkgroupRequest(
        baseCapacity.map(value => value),
        configParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enhancedVpcRouting.map(value => value),
        namespaceName,
        port.map(value => value),
        publiclyAccessible.map(value => value),
        securityGroupIds.map(value => value),
        subnetIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workgroupName
      )
    def baseCapacity: Optional[Integer]
    def configParameters: Optional[
      List[zio.aws.redshiftserverless.model.ConfigParameter.ReadOnly]
    ]
    def enhancedVpcRouting: Optional[Boolean]
    def namespaceName: NamespaceName
    def port: Optional[Integer]
    def publiclyAccessible: Optional[Boolean]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def subnetIds: Optional[List[SubnetId]]
    def tags: Optional[List[zio.aws.redshiftserverless.model.Tag.ReadOnly]]
    def workgroupName: WorkgroupName
    def getBaseCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("baseCapacity", baseCapacity)
    def getConfigParameters: ZIO[Any, AwsError, List[
      zio.aws.redshiftserverless.model.ConfigParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("configParameters", configParameters)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getNamespaceName: ZIO[Any, Nothing, NamespaceName] =
      ZIO.succeed(namespaceName)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.redshiftserverless.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getWorkgroupName: ZIO[Any, Nothing, WorkgroupName] =
      ZIO.succeed(workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupRequest
  ) extends zio.aws.redshiftserverless.model.CreateWorkgroupRequest.ReadOnly {
    override val baseCapacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.baseCapacity())
      .map(value => value: Integer)
    override val configParameters: Optional[
      List[zio.aws.redshiftserverless.model.ConfigParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftserverless.model.ConfigParameter.wrap(item)
        }.toList
      )
    override val enhancedVpcRouting: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enhancedVpcRouting())
      .map(value => value: Boolean)
    override val namespaceName: NamespaceName =
      zio.aws.redshiftserverless.model.primitives
        .NamespaceName(impl.namespaceName())
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftserverless.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftserverless.model.primitives.SubnetId(item)
        }.toList
      )
    override val tags
        : Optional[List[zio.aws.redshiftserverless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftserverless.model.Tag.wrap(item)
          }.toList
        )
    override val workgroupName: WorkgroupName =
      zio.aws.redshiftserverless.model.primitives
        .WorkgroupName(impl.workgroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateWorkgroupRequest
  ): zio.aws.redshiftserverless.model.CreateWorkgroupRequest.ReadOnly =
    new Wrapper(impl)
}
