package zio.aws.redshiftserverless.model
import scala.jdk.CollectionConverters._
sealed trait UsageLimitBreachAction {
  def unwrap: software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction
}
object UsageLimitBreachAction {
  def wrap(
      value: software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction
  ): zio.aws.redshiftserverless.model.UsageLimitBreachAction = value match {
    case software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction.LOG =>
      val r = log
      r
    case software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction.EMIT_METRIC =>
      val r = `emit-metric`
      r
    case software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction.DEACTIVATE =>
      val r = deactivate
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshiftserverless.model.UsageLimitBreachAction {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction =
      software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction.UNKNOWN_TO_SDK_VERSION
  }
  case object log
      extends zio.aws.redshiftserverless.model.UsageLimitBreachAction {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction =
      software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction.LOG
  }
  case object `emit-metric`
      extends zio.aws.redshiftserverless.model.UsageLimitBreachAction {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction =
      software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction.EMIT_METRIC
  }
  case object deactivate
      extends zio.aws.redshiftserverless.model.UsageLimitBreachAction {
    override def unwrap
        : software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction =
      software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction.DEACTIVATE
  }
}
