package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UsageLimit(
    amount: Optional[Long] = Optional.Absent,
    breachAction: Optional[
      zio.aws.redshiftserverless.model.UsageLimitBreachAction
    ] = Optional.Absent,
    period: Optional[zio.aws.redshiftserverless.model.UsageLimitPeriod] =
      Optional.Absent,
    resourceArn: Optional[String] = Optional.Absent,
    usageLimitArn: Optional[String] = Optional.Absent,
    usageLimitId: Optional[String] = Optional.Absent,
    usageType: Optional[zio.aws.redshiftserverless.model.UsageLimitUsageType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.UsageLimit = {
    import UsageLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.UsageLimit
      .builder()
      .optionallyWith(amount.map(value => value: java.lang.Long))(_.amount)
      .optionallyWith(breachAction.map(value => value.unwrap))(_.breachAction)
      .optionallyWith(period.map(value => value.unwrap))(_.period)
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .optionallyWith(usageLimitArn.map(value => value: java.lang.String))(
        _.usageLimitArn
      )
      .optionallyWith(usageLimitId.map(value => value: java.lang.String))(
        _.usageLimitId
      )
      .optionallyWith(usageType.map(value => value.unwrap))(_.usageType)
      .build()
  }
  def asReadOnly: zio.aws.redshiftserverless.model.UsageLimit.ReadOnly =
    zio.aws.redshiftserverless.model.UsageLimit.wrap(buildAwsValue())
}
object UsageLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.UsageLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.UsageLimit =
      zio.aws.redshiftserverless.model.UsageLimit(
        amount.map(value => value),
        breachAction.map(value => value),
        period.map(value => value),
        resourceArn.map(value => value),
        usageLimitArn.map(value => value),
        usageLimitId.map(value => value),
        usageType.map(value => value)
      )
    def amount: Optional[Long]
    def breachAction
        : Optional[zio.aws.redshiftserverless.model.UsageLimitBreachAction]
    def period: Optional[zio.aws.redshiftserverless.model.UsageLimitPeriod]
    def resourceArn: Optional[String]
    def usageLimitArn: Optional[String]
    def usageLimitId: Optional[String]
    def usageType
        : Optional[zio.aws.redshiftserverless.model.UsageLimitUsageType]
    def getAmount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("amount", amount)
    def getBreachAction: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.UsageLimitBreachAction
    ] = AwsError.unwrapOptionField("breachAction", breachAction)
    def getPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.UsageLimitPeriod
    ] = AwsError.unwrapOptionField("period", period)
    def getResourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getUsageLimitArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageLimitArn", usageLimitArn)
    def getUsageLimitId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageLimitId", usageLimitId)
    def getUsageType: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.UsageLimitUsageType
    ] = AwsError.unwrapOptionField("usageType", usageType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UsageLimit
  ) extends zio.aws.redshiftserverless.model.UsageLimit.ReadOnly {
    override val amount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.amount())
      .map(value => value: Long)
    override val breachAction
        : Optional[zio.aws.redshiftserverless.model.UsageLimitBreachAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.breachAction())
        .map(value =>
          zio.aws.redshiftserverless.model.UsageLimitBreachAction.wrap(value)
        )
    override val period
        : Optional[zio.aws.redshiftserverless.model.UsageLimitPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.period())
        .map(value =>
          zio.aws.redshiftserverless.model.UsageLimitPeriod.wrap(value)
        )
    override val resourceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => value: String)
    override val usageLimitArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usageLimitArn())
      .map(value => value: String)
    override val usageLimitId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usageLimitId())
      .map(value => value: String)
    override val usageType
        : Optional[zio.aws.redshiftserverless.model.UsageLimitUsageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageType())
        .map(value =>
          zio.aws.redshiftserverless.model.UsageLimitUsageType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UsageLimit
  ): zio.aws.redshiftserverless.model.UsageLimit.ReadOnly = new Wrapper(impl)
}
