package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyResponse(
    resourcePolicy: Optional[zio.aws.redshiftserverless.model.ResourcePolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyResponse = {
    import PutResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyResponse
      .builder()
      .optionallyWith(resourcePolicy.map(value => value.buildAwsValue()))(
        _.resourcePolicy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.PutResourcePolicyResponse.ReadOnly =
    zio.aws.redshiftserverless.model.PutResourcePolicyResponse
      .wrap(buildAwsValue())
}
object PutResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.PutResourcePolicyResponse =
      zio.aws.redshiftserverless.model.PutResourcePolicyResponse(
        resourcePolicy.map(value => value.asEditable)
      )
    def resourcePolicy
        : Optional[zio.aws.redshiftserverless.model.ResourcePolicy.ReadOnly]
    def getResourcePolicy: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.ResourcePolicy.ReadOnly
    ] = AwsError.unwrapOptionField("resourcePolicy", resourcePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyResponse
  ) extends zio.aws.redshiftserverless.model.PutResourcePolicyResponse.ReadOnly {
    override val resourcePolicy
        : Optional[zio.aws.redshiftserverless.model.ResourcePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcePolicy())
        .map(value =>
          zio.aws.redshiftserverless.model.ResourcePolicy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.PutResourcePolicyResponse
  ): zio.aws.redshiftserverless.model.PutResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
