package zio.aws.redshiftserverless.model
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.ListWorkgroupsRequestMaxResultsInteger
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListWorkgroupsRequest(
    maxResults: Optional[ListWorkgroupsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest = {
    import ListWorkgroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListWorkgroupsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListWorkgroupsRequest.ReadOnly =
    zio.aws.redshiftserverless.model.ListWorkgroupsRequest.wrap(buildAwsValue())
}
object ListWorkgroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.ListWorkgroupsRequest =
      zio.aws.redshiftserverless.model.ListWorkgroupsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListWorkgroupsRequestMaxResultsInteger]
    def nextToken: Optional[String]
    def getMaxResults
        : ZIO[Any, AwsError, ListWorkgroupsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest
  ) extends zio.aws.redshiftserverless.model.ListWorkgroupsRequest.ReadOnly {
    override val maxResults: Optional[ListWorkgroupsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives
            .ListWorkgroupsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsRequest
  ): zio.aws.redshiftserverless.model.ListWorkgroupsRequest.ReadOnly =
    new Wrapper(impl)
}
