package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.PaginationToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListUsageLimitsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    usageLimits: Optional[
      Iterable[zio.aws.redshiftserverless.model.UsageLimit]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse = {
    import ListUsageLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        usageLimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.usageLimits)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListUsageLimitsResponse.ReadOnly =
    zio.aws.redshiftserverless.model.ListUsageLimitsResponse
      .wrap(buildAwsValue())
}
object ListUsageLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.ListUsageLimitsResponse =
      zio.aws.redshiftserverless.model.ListUsageLimitsResponse(
        nextToken.map(value => value),
        usageLimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def usageLimits
        : Optional[List[zio.aws.redshiftserverless.model.UsageLimit.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getUsageLimits: ZIO[Any, AwsError, List[
      zio.aws.redshiftserverless.model.UsageLimit.ReadOnly
    ]] = AwsError.unwrapOptionField("usageLimits", usageLimits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse
  ) extends zio.aws.redshiftserverless.model.ListUsageLimitsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.PaginationToken(value)
      )
    override val usageLimits
        : Optional[List[zio.aws.redshiftserverless.model.UsageLimit.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageLimits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftserverless.model.UsageLimit.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsResponse
  ): zio.aws.redshiftserverless.model.ListUsageLimitsResponse.ReadOnly =
    new Wrapper(impl)
}
