package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetEndpointAccessRequest(endpointName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessRequest = {
    import GetEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessRequest
      .builder()
      .endpointName(endpointName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.GetEndpointAccessRequest.ReadOnly =
    zio.aws.redshiftserverless.model.GetEndpointAccessRequest
      .wrap(buildAwsValue())
}
object GetEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.GetEndpointAccessRequest =
      zio.aws.redshiftserverless.model.GetEndpointAccessRequest(endpointName)
    def endpointName: String
    def getEndpointName: ZIO[Any, Nothing, String] = ZIO.succeed(endpointName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessRequest
  ) extends zio.aws.redshiftserverless.model.GetEndpointAccessRequest.ReadOnly {
    override val endpointName: String = impl.endpointName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessRequest
  ): zio.aws.redshiftserverless.model.GetEndpointAccessRequest.ReadOnly =
    new Wrapper(impl)
}
