package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{ParameterValue, ParameterName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SqlParameter(name: ParameterName, value: ParameterValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.SqlParameter = {
    import SqlParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.SqlParameter
      .builder()
      .name(ParameterName.unwrap(name): java.lang.String)
      .value(ParameterValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.SqlParameter.ReadOnly =
    zio.aws.redshiftdata.model.SqlParameter.wrap(buildAwsValue())
}
object SqlParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.SqlParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.SqlParameter =
      zio.aws.redshiftdata.model.SqlParameter(name, value)
    def name: ParameterName
    def value: ParameterValue
    def getName: ZIO[Any, Nothing, ParameterName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, ParameterValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.SqlParameter
  ) extends zio.aws.redshiftdata.model.SqlParameter.ReadOnly {
    override val name: ParameterName =
      zio.aws.redshiftdata.model.primitives.ParameterName(impl.name())
    override val value: ParameterValue =
      zio.aws.redshiftdata.model.primitives.ParameterValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.SqlParameter
  ): zio.aws.redshiftdata.model.SqlParameter.ReadOnly = new Wrapper(impl)
}
