package zio.aws.redshiftdata.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftdata.model.primitives.{
  SecretArn,
  StatementString,
  Timestamp,
  StatementId,
  StatementNameString
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class StatementData(
    createdAt: Optional[Timestamp] = Optional.Absent,
    id: StatementId,
    isBatchStatement: Optional[Boolean] = Optional.Absent,
    queryParameters: Optional[
      Iterable[zio.aws.redshiftdata.model.SqlParameter]
    ] = Optional.Absent,
    queryString: Optional[StatementString] = Optional.Absent,
    queryStrings: Optional[Iterable[StatementString]] = Optional.Absent,
    secretArn: Optional[SecretArn] = Optional.Absent,
    statementName: Optional[StatementNameString] = Optional.Absent,
    status: Optional[zio.aws.redshiftdata.model.StatusString] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.StatementData = {
    import StatementData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.StatementData
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .id(StatementId.unwrap(id): java.lang.String)
      .optionallyWith(isBatchStatement.map(value => value: java.lang.Boolean))(
        _.isBatchStatement
      )
      .optionallyWith(
        queryParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queryParameters)
      .optionallyWith(
        queryString.map(value =>
          StatementString.unwrap(value): java.lang.String
        )
      )(_.queryString)
      .optionallyWith(
        queryStrings.map(value =>
          value.map { item =>
            StatementString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queryStrings)
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .optionallyWith(
        statementName.map(value =>
          StatementNameString.unwrap(value): java.lang.String
        )
      )(_.statementName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.StatementData.ReadOnly =
    zio.aws.redshiftdata.model.StatementData.wrap(buildAwsValue())
}
object StatementData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.StatementData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.StatementData =
      zio.aws.redshiftdata.model.StatementData(
        createdAt.map(value => value),
        id,
        isBatchStatement.map(value => value),
        queryParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        queryString.map(value => value),
        queryStrings.map(value => value),
        secretArn.map(value => value),
        statementName.map(value => value),
        status.map(value => value),
        updatedAt.map(value => value)
      )
    def createdAt: Optional[Timestamp]
    def id: StatementId
    def isBatchStatement: Optional[Boolean]
    def queryParameters
        : Optional[List[zio.aws.redshiftdata.model.SqlParameter.ReadOnly]]
    def queryString: Optional[StatementString]
    def queryStrings: Optional[List[StatementString]]
    def secretArn: Optional[SecretArn]
    def statementName: Optional[StatementNameString]
    def status: Optional[zio.aws.redshiftdata.model.StatusString]
    def updatedAt: Optional[Timestamp]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getId: ZIO[Any, Nothing, StatementId] = ZIO.succeed(id)
    def getIsBatchStatement: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isBatchStatement", isBatchStatement)
    def getQueryParameters: ZIO[Any, AwsError, List[
      zio.aws.redshiftdata.model.SqlParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("queryParameters", queryParameters)
    def getQueryString: ZIO[Any, AwsError, StatementString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getQueryStrings: ZIO[Any, AwsError, List[StatementString]] =
      AwsError.unwrapOptionField("queryStrings", queryStrings)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getStatementName: ZIO[Any, AwsError, StatementNameString] =
      AwsError.unwrapOptionField("statementName", statementName)
    def getStatus: ZIO[Any, AwsError, zio.aws.redshiftdata.model.StatusString] =
      AwsError.unwrapOptionField("status", status)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.StatementData
  ) extends zio.aws.redshiftdata.model.StatementData.ReadOnly {
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
    override val id: StatementId =
      zio.aws.redshiftdata.model.primitives.StatementId(impl.id())
    override val isBatchStatement: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isBatchStatement())
      .map(value => value: Boolean)
    override val queryParameters
        : Optional[List[zio.aws.redshiftdata.model.SqlParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftdata.model.SqlParameter.wrap(item)
          }.toList
        )
    override val queryString: Optional[StatementString] = zio.aws.core.internal
      .optionalFromNullable(impl.queryString())
      .map(value =>
        zio.aws.redshiftdata.model.primitives.StatementString(value)
      )
    override val queryStrings: Optional[List[StatementString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryStrings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftdata.model.primitives.StatementString(item)
          }.toList
        )
    override val secretArn: Optional[SecretArn] = zio.aws.core.internal
      .optionalFromNullable(impl.secretArn())
      .map(value => zio.aws.redshiftdata.model.primitives.SecretArn(value))
    override val statementName: Optional[StatementNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statementName())
        .map(value =>
          zio.aws.redshiftdata.model.primitives.StatementNameString(value)
        )
    override val status: Optional[zio.aws.redshiftdata.model.StatusString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.redshiftdata.model.StatusString.wrap(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.StatementData
  ): zio.aws.redshiftdata.model.StatementData.ReadOnly = new Wrapper(impl)
}
