package zio.aws.redshiftdata.model
import java.lang.Integer
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{
  StatementNameString,
  ListStatementsLimit
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListStatementsRequest(
    maxResults: Option[ListStatementsLimit] = None,
    nextToken: Option[String] = None,
    roleLevel: Option[Boolean] = None,
    statementName: Option[StatementNameString] = None,
    status: Option[zio.aws.redshiftdata.model.StatusString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest = {
    import ListStatementsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => ListStatementsLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(roleLevel.map(value => value: java.lang.Boolean))(
        _.roleLevel
      )
      .optionallyWith(
        statementName.map(value =>
          StatementNameString.unwrap(value): java.lang.String
        )
      )(_.statementName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.ListStatementsRequest.ReadOnly =
    zio.aws.redshiftdata.model.ListStatementsRequest.wrap(buildAwsValue())
}
object ListStatementsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.ListStatementsRequest =
      zio.aws.redshiftdata.model.ListStatementsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        roleLevel.map(value => value),
        statementName.map(value => value),
        status.map(value => value)
      )
    def maxResults: Option[ListStatementsLimit]
    def nextToken: Option[String]
    def roleLevel: Option[Boolean]
    def statementName: Option[StatementNameString]
    def status: Option[zio.aws.redshiftdata.model.StatusString]
    def getMaxResults: ZIO[Any, AwsError, ListStatementsLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRoleLevel: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("roleLevel", roleLevel)
    def getStatementName: ZIO[Any, AwsError, StatementNameString] =
      AwsError.unwrapOptionField("statementName", statementName)
    def getStatus: ZIO[Any, AwsError, zio.aws.redshiftdata.model.StatusString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest
  ) extends zio.aws.redshiftdata.model.ListStatementsRequest.ReadOnly {
    override val maxResults: Option[ListStatementsLimit] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.redshiftdata.model.primitives.ListStatementsLimit(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val roleLevel: Option[Boolean] =
      scala.Option(impl.roleLevel()).map(value => value: Boolean)
    override val statementName: Option[StatementNameString] = scala
      .Option(impl.statementName())
      .map(value =>
        zio.aws.redshiftdata.model.primitives.StatementNameString(value)
      )
    override val status: Option[zio.aws.redshiftdata.model.StatusString] = scala
      .Option(impl.status())
      .map(value => zio.aws.redshiftdata.model.StatusString.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest
  ): zio.aws.redshiftdata.model.ListStatementsRequest.ReadOnly = new Wrapper(
    impl
  )
}
