package zio.aws.redshiftdata.model
import scala.jdk.CollectionConverters.*
sealed trait StatementStatusString {
  def unwrap
      : software.amazon.awssdk.services.redshiftdata.model.StatementStatusString
}
object StatementStatusString {
  def wrap(
      value: software.amazon.awssdk.services.redshiftdata.model.StatementStatusString
  ): zio.aws.redshiftdata.model.StatementStatusString = value match {
    case software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.SUBMITTED =>
      val r = SUBMITTED
      r
    case software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.PICKED =>
      val r = PICKED
      r
    case software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.STARTED =>
      val r = STARTED
      r
    case software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.FINISHED =>
      val r = FINISHED
      r
    case software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.ABORTED =>
      val r = ABORTED
      r
    case software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshiftdata.model.StatementStatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatementStatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.UNKNOWN_TO_SDK_VERSION
  }
  case object SUBMITTED
      extends zio.aws.redshiftdata.model.StatementStatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatementStatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.SUBMITTED
  }
  case object PICKED extends zio.aws.redshiftdata.model.StatementStatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatementStatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.PICKED
  }
  case object STARTED extends zio.aws.redshiftdata.model.StatementStatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatementStatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.STARTED
  }
  case object FINISHED
      extends zio.aws.redshiftdata.model.StatementStatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatementStatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.FINISHED
  }
  case object ABORTED extends zio.aws.redshiftdata.model.StatementStatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatementStatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.ABORTED
  }
  case object FAILED extends zio.aws.redshiftdata.model.StatementStatusString {
    override def unwrap
        : software.amazon.awssdk.services.redshiftdata.model.StatementStatusString =
      software.amazon.awssdk.services.redshiftdata.model.StatementStatusString.FAILED
  }
}
