package zio.aws.redshiftdata
import zio.aws.redshiftdata.model.primitives.Blob.Type
import java.time.Instant
import zio.aws.redshiftdata.model.primitives.StatementString
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Blob extends Subtype[Chunk[Byte]]
    type Blob = zio.aws.redshiftdata.model.primitives.Blob.Type
    type Bool = Boolean
    type BoxedBoolean = Boolean
    type BoxedDouble = Double
    type BoxedLong = Long
    type Integer = Int
    object ListStatementsLimit extends Subtype[Int]
    type ListStatementsLimit =
      zio.aws.redshiftdata.model.primitives.ListStatementsLimit.Type
    object Location extends Subtype[String]
    type Location = zio.aws.redshiftdata.model.primitives.Location.Type
    object PageSize extends Subtype[Int]
    type PageSize = zio.aws.redshiftdata.model.primitives.PageSize.Type
    object ParameterName extends Subtype[String]
    type ParameterName =
      zio.aws.redshiftdata.model.primitives.ParameterName.Type
    object ParameterValue extends Subtype[String]
    type ParameterValue =
      zio.aws.redshiftdata.model.primitives.ParameterValue.Type
    object SecretArn extends Subtype[String]
    type SecretArn = zio.aws.redshiftdata.model.primitives.SecretArn.Type
    object StatementId extends Subtype[String]
    type StatementId = zio.aws.redshiftdata.model.primitives.StatementId.Type
    object StatementNameString extends Subtype[String]
    type StatementNameString =
      zio.aws.redshiftdata.model.primitives.StatementNameString.Type
    object StatementString extends Subtype[String]
    type StatementString =
      zio.aws.redshiftdata.model.primitives.StatementString.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.redshiftdata.model.primitives.Timestamp.Type
  }
  type ColumnList = List[zio.aws.redshiftdata.model.ColumnMetadata]
  type ColumnMetadataList = List[zio.aws.redshiftdata.model.ColumnMetadata]
  type DatabaseList = List[String]
  type FieldList = List[zio.aws.redshiftdata.model.Field]
  type SchemaList = List[String]
  type SqlList = List[StatementString]
  type SqlParametersList = List[zio.aws.redshiftdata.model.SqlParameter]
  type SqlRecords = List[Iterable[zio.aws.redshiftdata.model.Field]]
  type StatementList = List[zio.aws.redshiftdata.model.StatementData]
  type StatementStringList = List[StatementString]
  type SubStatementList = List[zio.aws.redshiftdata.model.SubStatementData]
  type TableList = List[zio.aws.redshiftdata.model.TableMember]
}
