package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{
  StatementNameString,
  StatementString,
  SecretArn,
  Location
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExecuteStatementRequest(
    clusterIdentifier: Option[Location] = None,
    database: String,
    dbUser: Option[String] = None,
    parameters: Option[Iterable[zio.aws.redshiftdata.model.SqlParameter]] =
      None,
    secretArn: Option[SecretArn] = None,
    sql: StatementString,
    statementName: Option[StatementNameString] = None,
    withEvent: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementRequest = {
    import ExecuteStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementRequest
      .builder()
      .optionallyWith(
        clusterIdentifier.map(value => Location.unwrap(value): java.lang.String)
      )(_.clusterIdentifier)
      .database(database: java.lang.String)
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .sql(StatementString.unwrap(sql): java.lang.String)
      .optionallyWith(
        statementName.map(value =>
          StatementNameString.unwrap(value): java.lang.String
        )
      )(_.statementName)
      .optionallyWith(withEvent.map(value => value: java.lang.Boolean))(
        _.withEvent
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.ExecuteStatementRequest.ReadOnly =
    zio.aws.redshiftdata.model.ExecuteStatementRequest.wrap(buildAwsValue())
}
object ExecuteStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.ExecuteStatementRequest =
      zio.aws.redshiftdata.model.ExecuteStatementRequest(
        clusterIdentifier.map(value => value),
        database,
        dbUser.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secretArn.map(value => value),
        sql,
        statementName.map(value => value),
        withEvent.map(value => value)
      )
    def clusterIdentifier: Option[Location]
    def database: String
    def dbUser: Option[String]
    def parameters
        : Option[List[zio.aws.redshiftdata.model.SqlParameter.ReadOnly]]
    def secretArn: Option[SecretArn]
    def sql: StatementString
    def statementName: Option[StatementNameString]
    def withEvent: Option[Boolean]
    def getClusterIdentifier: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getDatabase: ZIO[Any, Nothing, String] = ZIO.succeed(database)
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.redshiftdata.model.SqlParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getSql: ZIO[Any, Nothing, StatementString] = ZIO.succeed(sql)
    def getStatementName: ZIO[Any, AwsError, StatementNameString] =
      AwsError.unwrapOptionField("statementName", statementName)
    def getWithEvent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("withEvent", withEvent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementRequest
  ) extends zio.aws.redshiftdata.model.ExecuteStatementRequest.ReadOnly {
    override val clusterIdentifier: Option[Location] = scala
      .Option(impl.clusterIdentifier())
      .map(value => zio.aws.redshiftdata.model.primitives.Location(value))
    override val database: String = impl.database(): String
    override val dbUser: Option[String] =
      scala.Option(impl.dbUser()).map(value => value: String)
    override val parameters
        : Option[List[zio.aws.redshiftdata.model.SqlParameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftdata.model.SqlParameter.wrap(item)
        }.toList
      )
    override val secretArn: Option[SecretArn] = scala
      .Option(impl.secretArn())
      .map(value => zio.aws.redshiftdata.model.primitives.SecretArn(value))
    override val sql: StatementString =
      zio.aws.redshiftdata.model.primitives.StatementString(impl.sql())
    override val statementName: Option[StatementNameString] = scala
      .Option(impl.statementName())
      .map(value =>
        zio.aws.redshiftdata.model.primitives.StatementNameString(value)
      )
    override val withEvent: Option[Boolean] =
      scala.Option(impl.withEvent()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementRequest
  ): zio.aws.redshiftdata.model.ExecuteStatementRequest.ReadOnly = new Wrapper(
    impl
  )
}
