package zio.aws.redshiftdata.model
import java.lang.Integer
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{SecretArn, PageSize, Location}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTablesRequest(
    clusterIdentifier: Option[Location] = None,
    connectedDatabase: Option[String] = None,
    database: String,
    dbUser: Option[String] = None,
    maxResults: Option[PageSize] = None,
    nextToken: Option[String] = None,
    schemaPattern: Option[String] = None,
    secretArn: Option[SecretArn] = None,
    tablePattern: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest = {
    import ListTablesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest
      .builder()
      .optionallyWith(
        clusterIdentifier.map(value => Location.unwrap(value): java.lang.String)
      )(_.clusterIdentifier)
      .optionallyWith(connectedDatabase.map(value => value: java.lang.String))(
        _.connectedDatabase
      )
      .database(database: java.lang.String)
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(schemaPattern.map(value => value: java.lang.String))(
        _.schemaPattern
      )
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .optionallyWith(tablePattern.map(value => value: java.lang.String))(
        _.tablePattern
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.ListTablesRequest.ReadOnly =
    zio.aws.redshiftdata.model.ListTablesRequest.wrap(buildAwsValue())
}
object ListTablesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.ListTablesRequest =
      zio.aws.redshiftdata.model.ListTablesRequest(
        clusterIdentifier.map(value => value),
        connectedDatabase.map(value => value),
        database,
        dbUser.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        schemaPattern.map(value => value),
        secretArn.map(value => value),
        tablePattern.map(value => value)
      )
    def clusterIdentifier: Option[Location]
    def connectedDatabase: Option[String]
    def database: String
    def dbUser: Option[String]
    def maxResults: Option[PageSize]
    def nextToken: Option[String]
    def schemaPattern: Option[String]
    def secretArn: Option[SecretArn]
    def tablePattern: Option[String]
    def getClusterIdentifier: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getConnectedDatabase: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectedDatabase", connectedDatabase)
    def getDatabase: ZIO[Any, Nothing, String] = ZIO.succeed(database)
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSchemaPattern: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaPattern", schemaPattern)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getTablePattern: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tablePattern", tablePattern)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest
  ) extends zio.aws.redshiftdata.model.ListTablesRequest.ReadOnly {
    override val clusterIdentifier: Option[Location] = scala
      .Option(impl.clusterIdentifier())
      .map(value => zio.aws.redshiftdata.model.primitives.Location(value))
    override val connectedDatabase: Option[String] =
      scala.Option(impl.connectedDatabase()).map(value => value: String)
    override val database: String = impl.database(): String
    override val dbUser: Option[String] =
      scala.Option(impl.dbUser()).map(value => value: String)
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.redshiftdata.model.primitives.PageSize(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val schemaPattern: Option[String] =
      scala.Option(impl.schemaPattern()).map(value => value: String)
    override val secretArn: Option[SecretArn] = scala
      .Option(impl.secretArn())
      .map(value => zio.aws.redshiftdata.model.primitives.SecretArn(value))
    override val tablePattern: Option[String] =
      scala.Option(impl.tablePattern()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest
  ): zio.aws.redshiftdata.model.ListTablesRequest.ReadOnly = new Wrapper(impl)
}
