package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{
  SecretArn,
  StatementId,
  Timestamp,
  Location
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ExecuteStatementResponse(
    clusterIdentifier: Option[Location] = None,
    createdAt: Option[Timestamp] = None,
    database: Option[String] = None,
    dbUser: Option[String] = None,
    id: Option[StatementId] = None,
    secretArn: Option[SecretArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementResponse = {
    import ExecuteStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementResponse
      .builder()
      .optionallyWith(
        clusterIdentifier.map(value => Location.unwrap(value): java.lang.String)
      )(_.clusterIdentifier)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(database.map(value => value: java.lang.String))(
        _.database
      )
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(
        id.map(value => StatementId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.ExecuteStatementResponse.ReadOnly =
    zio.aws.redshiftdata.model.ExecuteStatementResponse.wrap(buildAwsValue())
}
object ExecuteStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.ExecuteStatementResponse =
      zio.aws.redshiftdata.model.ExecuteStatementResponse(
        clusterIdentifier.map(value => value),
        createdAt.map(value => value),
        database.map(value => value),
        dbUser.map(value => value),
        id.map(value => value),
        secretArn.map(value => value)
      )
    def clusterIdentifier: Option[Location]
    def createdAt: Option[Timestamp]
    def database: Option[String]
    def dbUser: Option[String]
    def id: Option[StatementId]
    def secretArn: Option[SecretArn]
    def getClusterIdentifier: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDatabase: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("database", database)
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getId: ZIO[Any, AwsError, StatementId] =
      AwsError.unwrapOptionField("id", id)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementResponse
  ) extends zio.aws.redshiftdata.model.ExecuteStatementResponse.ReadOnly {
    override val clusterIdentifier: Option[Location] = scala
      .Option(impl.clusterIdentifier())
      .map(value => zio.aws.redshiftdata.model.primitives.Location(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
    override val database: Option[String] =
      scala.Option(impl.database()).map(value => value: String)
    override val dbUser: Option[String] =
      scala.Option(impl.dbUser()).map(value => value: String)
    override val id: Option[StatementId] = scala
      .Option(impl.id())
      .map(value => zio.aws.redshiftdata.model.primitives.StatementId(value))
    override val secretArn: Option[SecretArn] = scala
      .Option(impl.secretArn())
      .map(value => zio.aws.redshiftdata.model.primitives.SecretArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementResponse
  ): zio.aws.redshiftdata.model.ExecuteStatementResponse.ReadOnly = new Wrapper(
    impl
  )
}
