package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{
  BoxedLong,
  BoxedDouble,
  BoxedBoolean,
  Blob
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Field(
    blobValue: Option[Blob] = None,
    booleanValue: Option[BoxedBoolean] = None,
    doubleValue: Option[BoxedDouble] = None,
    isNull: Option[BoxedBoolean] = None,
    longValue: Option[BoxedLong] = None,
    stringValue: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.Field = {
    import Field.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.Field
      .builder()
      .optionallyWith(
        blobValue.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.blobValue)
      .optionallyWith(
        booleanValue.map(value => BoxedBoolean.unwrap(value): java.lang.Boolean)
      )(_.booleanValue)
      .optionallyWith(
        doubleValue.map(value => BoxedDouble.unwrap(value): java.lang.Double)
      )(_.doubleValue)
      .optionallyWith(
        isNull.map(value => BoxedBoolean.unwrap(value): java.lang.Boolean)
      )(_.isNull)
      .optionallyWith(
        longValue.map(value => BoxedLong.unwrap(value): java.lang.Long)
      )(_.longValue)
      .optionallyWith(stringValue.map(value => value: java.lang.String))(
        _.stringValue
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.Field.ReadOnly =
    zio.aws.redshiftdata.model.Field.wrap(buildAwsValue())
}
object Field {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.Field
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.Field =
      zio.aws.redshiftdata.model.Field(
        blobValue.map(value => value),
        booleanValue.map(value => value),
        doubleValue.map(value => value),
        isNull.map(value => value),
        longValue.map(value => value),
        stringValue.map(value => value)
      )
    def blobValue: Option[Blob]
    def booleanValue: Option[BoxedBoolean]
    def doubleValue: Option[BoxedDouble]
    def isNull: Option[BoxedBoolean]
    def longValue: Option[BoxedLong]
    def stringValue: Option[String]
    def getBlobValue: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("blobValue", blobValue)
    def getBooleanValue: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("booleanValue", booleanValue)
    def getDoubleValue: ZIO[Any, AwsError, BoxedDouble] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getIsNull: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("isNull", isNull)
    def getLongValue: ZIO[Any, AwsError, BoxedLong] =
      AwsError.unwrapOptionField("longValue", longValue)
    def getStringValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stringValue", stringValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.Field
  ) extends zio.aws.redshiftdata.model.Field.ReadOnly {
    override val blobValue: Option[Blob] = scala
      .Option(impl.blobValue())
      .map(value =>
        zio.aws.redshiftdata.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val booleanValue: Option[BoxedBoolean] = scala
      .Option(impl.booleanValue())
      .map(value => zio.aws.redshiftdata.model.primitives.BoxedBoolean(value))
    override val doubleValue: Option[BoxedDouble] = scala
      .Option(impl.doubleValue())
      .map(value => zio.aws.redshiftdata.model.primitives.BoxedDouble(value))
    override val isNull: Option[BoxedBoolean] = scala
      .Option(impl.isNull())
      .map(value => zio.aws.redshiftdata.model.primitives.BoxedBoolean(value))
    override val longValue: Option[BoxedLong] = scala
      .Option(impl.longValue())
      .map(value => zio.aws.redshiftdata.model.primitives.BoxedLong(value))
    override val stringValue: Option[String] =
      scala.Option(impl.stringValue()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.Field
  ): zio.aws.redshiftdata.model.Field.ReadOnly = new Wrapper(impl)
}
