package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{
  SecretArn,
  StatementString,
  StatementId,
  Timestamp
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeStatementResponse(
    clusterIdentifier: Option[String] = None,
    createdAt: Option[Timestamp] = None,
    database: Option[String] = None,
    dbUser: Option[String] = None,
    duration: Option[Long] = None,
    error: Option[String] = None,
    hasResultSet: Option[Boolean] = None,
    id: StatementId,
    queryParameters: Option[Iterable[zio.aws.redshiftdata.model.SqlParameter]] =
      None,
    queryString: Option[StatementString] = None,
    redshiftPid: Option[Long] = None,
    redshiftQueryId: Option[Long] = None,
    resultRows: Option[Long] = None,
    resultSize: Option[Long] = None,
    secretArn: Option[SecretArn] = None,
    status: Option[zio.aws.redshiftdata.model.StatusString] = None,
    subStatements: Option[
      Iterable[zio.aws.redshiftdata.model.SubStatementData]
    ] = None,
    updatedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse = {
    import DescribeStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(database.map(value => value: java.lang.String))(
        _.database
      )
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(duration.map(value => value: java.lang.Long))(_.duration)
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .optionallyWith(hasResultSet.map(value => value: java.lang.Boolean))(
        _.hasResultSet
      )
      .id(StatementId.unwrap(id): java.lang.String)
      .optionallyWith(
        queryParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queryParameters)
      .optionallyWith(
        queryString.map(value =>
          StatementString.unwrap(value): java.lang.String
        )
      )(_.queryString)
      .optionallyWith(redshiftPid.map(value => value: java.lang.Long))(
        _.redshiftPid
      )
      .optionallyWith(redshiftQueryId.map(value => value: java.lang.Long))(
        _.redshiftQueryId
      )
      .optionallyWith(resultRows.map(value => value: java.lang.Long))(
        _.resultRows
      )
      .optionallyWith(resultSize.map(value => value: java.lang.Long))(
        _.resultSize
      )
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        subStatements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subStatements)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftdata.model.DescribeStatementResponse.ReadOnly =
    zio.aws.redshiftdata.model.DescribeStatementResponse.wrap(buildAwsValue())
}
object DescribeStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.DescribeStatementResponse =
      zio.aws.redshiftdata.model.DescribeStatementResponse(
        clusterIdentifier.map(value => value),
        createdAt.map(value => value),
        database.map(value => value),
        dbUser.map(value => value),
        duration.map(value => value),
        error.map(value => value),
        hasResultSet.map(value => value),
        id,
        queryParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        queryString.map(value => value),
        redshiftPid.map(value => value),
        redshiftQueryId.map(value => value),
        resultRows.map(value => value),
        resultSize.map(value => value),
        secretArn.map(value => value),
        status.map(value => value),
        subStatements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updatedAt.map(value => value)
      )
    def clusterIdentifier: Option[String]
    def createdAt: Option[Timestamp]
    def database: Option[String]
    def dbUser: Option[String]
    def duration: Option[Long]
    def error: Option[String]
    def hasResultSet: Option[Boolean]
    def id: StatementId
    def queryParameters
        : Option[List[zio.aws.redshiftdata.model.SqlParameter.ReadOnly]]
    def queryString: Option[StatementString]
    def redshiftPid: Option[Long]
    def redshiftQueryId: Option[Long]
    def resultRows: Option[Long]
    def resultSize: Option[Long]
    def secretArn: Option[SecretArn]
    def status: Option[zio.aws.redshiftdata.model.StatusString]
    def subStatements
        : Option[List[zio.aws.redshiftdata.model.SubStatementData.ReadOnly]]
    def updatedAt: Option[Timestamp]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDatabase: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("database", database)
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getDuration: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("duration", duration)
    def getError: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("error", error)
    def getHasResultSet: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hasResultSet", hasResultSet)
    def getId: ZIO[Any, Nothing, StatementId] = ZIO.succeed(id)
    def getQueryParameters: ZIO[Any, AwsError, List[
      zio.aws.redshiftdata.model.SqlParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("queryParameters", queryParameters)
    def getQueryString: ZIO[Any, AwsError, StatementString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getRedshiftPid: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("redshiftPid", redshiftPid)
    def getRedshiftQueryId: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("redshiftQueryId", redshiftQueryId)
    def getResultRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("resultRows", resultRows)
    def getResultSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("resultSize", resultSize)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.redshiftdata.model.StatusString] =
      AwsError.unwrapOptionField("status", status)
    def getSubStatements: ZIO[Any, AwsError, List[
      zio.aws.redshiftdata.model.SubStatementData.ReadOnly
    ]] = AwsError.unwrapOptionField("subStatements", subStatements)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse
  ) extends zio.aws.redshiftdata.model.DescribeStatementResponse.ReadOnly {
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
    override val database: Option[String] =
      scala.Option(impl.database()).map(value => value: String)
    override val dbUser: Option[String] =
      scala.Option(impl.dbUser()).map(value => value: String)
    override val duration: Option[Long] =
      scala.Option(impl.duration()).map(value => value: Long)
    override val error: Option[String] =
      scala.Option(impl.error()).map(value => value: String)
    override val hasResultSet: Option[Boolean] =
      scala.Option(impl.hasResultSet()).map(value => value: Boolean)
    override val id: StatementId =
      zio.aws.redshiftdata.model.primitives.StatementId(impl.id())
    override val queryParameters
        : Option[List[zio.aws.redshiftdata.model.SqlParameter.ReadOnly]] = scala
      .Option(impl.queryParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftdata.model.SqlParameter.wrap(item)
        }.toList
      )
    override val queryString: Option[StatementString] = scala
      .Option(impl.queryString())
      .map(value =>
        zio.aws.redshiftdata.model.primitives.StatementString(value)
      )
    override val redshiftPid: Option[Long] =
      scala.Option(impl.redshiftPid()).map(value => value: Long)
    override val redshiftQueryId: Option[Long] =
      scala.Option(impl.redshiftQueryId()).map(value => value: Long)
    override val resultRows: Option[Long] =
      scala.Option(impl.resultRows()).map(value => value: Long)
    override val resultSize: Option[Long] =
      scala.Option(impl.resultSize()).map(value => value: Long)
    override val secretArn: Option[SecretArn] = scala
      .Option(impl.secretArn())
      .map(value => zio.aws.redshiftdata.model.primitives.SecretArn(value))
    override val status: Option[zio.aws.redshiftdata.model.StatusString] = scala
      .Option(impl.status())
      .map(value => zio.aws.redshiftdata.model.StatusString.wrap(value))
    override val subStatements
        : Option[List[zio.aws.redshiftdata.model.SubStatementData.ReadOnly]] =
      scala
        .Option(impl.subStatements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftdata.model.SubStatementData.wrap(item)
          }.toList
        )
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse
  ): zio.aws.redshiftdata.model.DescribeStatementResponse.ReadOnly =
    new Wrapper(impl)
}
