package zio.aws.redshiftdata
import zio.aws.redshiftdata.model.ListTablesResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.redshiftdata.{
  RedshiftDataAsyncClientBuilder,
  RedshiftDataAsyncClient
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.redshiftdata.paginators.GetStatementResultPublisher
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.redshiftdata.model.{
  TableMember,
  CancelStatementResponse,
  ExecuteStatementRequest,
  ExecuteStatementResponse,
  DescribeTableRequest,
  ListDatabasesResponse,
  ListSchemasRequest,
  GetStatementResultRequest,
  Field,
  ListDatabasesRequest,
  ListSchemasResponse,
  DescribeStatementRequest,
  GetStatementResultResponse,
  ColumnMetadata,
  ListStatementsRequest,
  BatchExecuteStatementRequest,
  DescribeTableResponse,
  ListTablesResponse,
  CancelStatementRequest,
  ListStatementsResponse,
  BatchExecuteStatementResponse,
  DescribeStatementResponse,
  ListTablesRequest,
  StatementData
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait RedshiftData extends AspectSupport[RedshiftData] {
  val api: RedshiftDataAsyncClient
  def listDatabases(
      request: zio.aws.redshiftdata.model.ListDatabasesRequest
  ): ZStream[Any, AwsError, String]
  def listDatabasesPaginated(
      request: zio.aws.redshiftdata.model.ListDatabasesRequest
  ): IO[AwsError, zio.aws.redshiftdata.model.ListDatabasesResponse.ReadOnly]
  def batchExecuteStatement(
      request: zio.aws.redshiftdata.model.BatchExecuteStatementRequest
  ): IO[
    AwsError,
    zio.aws.redshiftdata.model.BatchExecuteStatementResponse.ReadOnly
  ]
  def executeStatement(
      request: zio.aws.redshiftdata.model.ExecuteStatementRequest
  ): IO[AwsError, zio.aws.redshiftdata.model.ExecuteStatementResponse.ReadOnly]
  def listStatements(
      request: zio.aws.redshiftdata.model.ListStatementsRequest
  ): ZStream[Any, AwsError, zio.aws.redshiftdata.model.StatementData.ReadOnly]
  def listStatementsPaginated(
      request: zio.aws.redshiftdata.model.ListStatementsRequest
  ): IO[AwsError, zio.aws.redshiftdata.model.ListStatementsResponse.ReadOnly]
  def listTables(
      request: zio.aws.redshiftdata.model.ListTablesRequest
  ): ZStream[Any, AwsError, zio.aws.redshiftdata.model.TableMember.ReadOnly]
  def listTablesPaginated(
      request: zio.aws.redshiftdata.model.ListTablesRequest
  ): IO[AwsError, ReadOnly]
  def describeTable(
      request: zio.aws.redshiftdata.model.DescribeTableRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.redshiftdata.model.DescribeTableResponse.ReadOnly,
    zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly
  ]]
  def describeTablePaginated(
      request: zio.aws.redshiftdata.model.DescribeTableRequest
  ): IO[AwsError, zio.aws.redshiftdata.model.DescribeTableResponse.ReadOnly]
  def cancelStatement(
      request: zio.aws.redshiftdata.model.CancelStatementRequest
  ): IO[AwsError, zio.aws.redshiftdata.model.CancelStatementResponse.ReadOnly]
  def getStatementResult(
      request: zio.aws.redshiftdata.model.GetStatementResultRequest
  ): ZStream[Any, AwsError, List[zio.aws.redshiftdata.model.Field.ReadOnly]]
  def getStatementResultPaginated(
      request: zio.aws.redshiftdata.model.GetStatementResultRequest
  ): IO[
    AwsError,
    zio.aws.redshiftdata.model.GetStatementResultResponse.ReadOnly
  ]
  def listSchemas(
      request: zio.aws.redshiftdata.model.ListSchemasRequest
  ): ZStream[Any, AwsError, String]
  def listSchemasPaginated(
      request: zio.aws.redshiftdata.model.ListSchemasRequest
  ): IO[AwsError, zio.aws.redshiftdata.model.ListSchemasResponse.ReadOnly]
  def describeStatement(
      request: zio.aws.redshiftdata.model.DescribeStatementRequest
  ): IO[AwsError, zio.aws.redshiftdata.model.DescribeStatementResponse.ReadOnly]
}
object RedshiftData {
  val live: ZLayer[AwsConfig, java.lang.Throwable, RedshiftData] = customized(
    identity
  )
  def customized(
      customization: RedshiftDataAsyncClientBuilder => RedshiftDataAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, RedshiftData] = managed(
    customization
  ).toLayer
  def managed(
      customization: RedshiftDataAsyncClientBuilder => RedshiftDataAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, RedshiftData] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = RedshiftDataAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[RedshiftDataAsyncClient, RedshiftDataAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        RedshiftDataAsyncClient,
        RedshiftDataAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new RedshiftDataImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class RedshiftDataImpl[R](
      override val api: RedshiftDataAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends RedshiftData
      with AwsServiceBase[R] {
    override val serviceName: String = "RedshiftData"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): RedshiftDataImpl[R1] = new RedshiftDataImpl(api, newAspect, r)
    def listDatabases(
        request: zio.aws.redshiftdata.model.ListDatabasesRequest
    ): ZStream[Any, AwsError, String] = asyncSimplePaginatedRequest[
      ListDatabasesRequest,
      ListDatabasesResponse,
      java.lang.String
    ](
      "listDatabases",
      api.listDatabases,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.databases().asScala)
    )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listDatabasesPaginated(
        request: zio.aws.redshiftdata.model.ListDatabasesRequest
    ): IO[AwsError, zio.aws.redshiftdata.model.ListDatabasesResponse.ReadOnly] =
      asyncRequestResponse[ListDatabasesRequest, ListDatabasesResponse](
        "listDatabases",
        api.listDatabases
      )(request.buildAwsValue())
        .map(zio.aws.redshiftdata.model.ListDatabasesResponse.wrap)
        .provideEnvironment(r)
    def batchExecuteStatement(
        request: zio.aws.redshiftdata.model.BatchExecuteStatementRequest
    ): IO[
      AwsError,
      zio.aws.redshiftdata.model.BatchExecuteStatementResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchExecuteStatementRequest,
      BatchExecuteStatementResponse
    ]("batchExecuteStatement", api.batchExecuteStatement)(
      request.buildAwsValue()
    ).map(zio.aws.redshiftdata.model.BatchExecuteStatementResponse.wrap)
      .provideEnvironment(r)
    def executeStatement(
        request: zio.aws.redshiftdata.model.ExecuteStatementRequest
    ): IO[
      AwsError,
      zio.aws.redshiftdata.model.ExecuteStatementResponse.ReadOnly
    ] = asyncRequestResponse[ExecuteStatementRequest, ExecuteStatementResponse](
      "executeStatement",
      api.executeStatement
    )(request.buildAwsValue())
      .map(zio.aws.redshiftdata.model.ExecuteStatementResponse.wrap)
      .provideEnvironment(r)
    def listStatements(
        request: zio.aws.redshiftdata.model.ListStatementsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.redshiftdata.model.StatementData.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListStatementsRequest,
      ListStatementsResponse,
      StatementData
    ](
      "listStatements",
      api.listStatements,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.statements().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.redshiftdata.model.StatementData.wrap(item))
      .provideEnvironment(r)
    def listStatementsPaginated(
        request: zio.aws.redshiftdata.model.ListStatementsRequest
    ): IO[
      AwsError,
      zio.aws.redshiftdata.model.ListStatementsResponse.ReadOnly
    ] = asyncRequestResponse[ListStatementsRequest, ListStatementsResponse](
      "listStatements",
      api.listStatements
    )(request.buildAwsValue())
      .map(zio.aws.redshiftdata.model.ListStatementsResponse.wrap)
      .provideEnvironment(r)
    def listTables(
        request: zio.aws.redshiftdata.model.ListTablesRequest
    ): ZStream[Any, AwsError, zio.aws.redshiftdata.model.TableMember.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListTablesRequest,
        ListTablesResponse,
        TableMember
      ](
        "listTables",
        api.listTables,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tables().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.redshiftdata.model.TableMember.wrap(item))
        .provideEnvironment(r)
    def listTablesPaginated(
        request: zio.aws.redshiftdata.model.ListTablesRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[ListTablesRequest, ListTablesResponse](
        "listTables",
        api.listTables
      )(request.buildAwsValue())
        .map(zio.aws.redshiftdata.model.ListTablesResponse.wrap)
        .provideEnvironment(r)
    def describeTable(
        request: zio.aws.redshiftdata.model.DescribeTableRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.redshiftdata.model.DescribeTableResponse.ReadOnly,
      zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly
    ]] = asyncPaginatedRequest[
      DescribeTableRequest,
      DescribeTableResponse,
      ColumnMetadata
    ](
      "describeTable",
      api.describeTable,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.columnList().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.redshiftdata.model.DescribeTableResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.redshiftdata.model.ColumnMetadata.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeTablePaginated(
        request: zio.aws.redshiftdata.model.DescribeTableRequest
    ): IO[AwsError, zio.aws.redshiftdata.model.DescribeTableResponse.ReadOnly] =
      asyncRequestResponse[DescribeTableRequest, DescribeTableResponse](
        "describeTable",
        api.describeTable
      )(request.buildAwsValue())
        .map(zio.aws.redshiftdata.model.DescribeTableResponse.wrap)
        .provideEnvironment(r)
    def cancelStatement(
        request: zio.aws.redshiftdata.model.CancelStatementRequest
    ): IO[
      AwsError,
      zio.aws.redshiftdata.model.CancelStatementResponse.ReadOnly
    ] = asyncRequestResponse[CancelStatementRequest, CancelStatementResponse](
      "cancelStatement",
      api.cancelStatement
    )(request.buildAwsValue())
      .map(zio.aws.redshiftdata.model.CancelStatementResponse.wrap)
      .provideEnvironment(r)
    def getStatementResult(
        request: zio.aws.redshiftdata.model.GetStatementResultRequest
    ): ZStream[Any, AwsError, List[zio.aws.redshiftdata.model.Field.ReadOnly]] =
      asyncJavaPaginatedRequest[GetStatementResultRequest, java.util.List[
        Field
      ], GetStatementResultPublisher](
        "getStatementResult",
        api.getStatementResultPaginator,
        _.records()
      )(request.buildAwsValue())
        .map(item =>
          item.asScala.map { item =>
            zio.aws.redshiftdata.model.Field.wrap(item)
          }.toList
        )
        .provideEnvironment(r)
    def getStatementResultPaginated(
        request: zio.aws.redshiftdata.model.GetStatementResultRequest
    ): IO[
      AwsError,
      zio.aws.redshiftdata.model.GetStatementResultResponse.ReadOnly
    ] = asyncRequestResponse[
      GetStatementResultRequest,
      GetStatementResultResponse
    ]("getStatementResult", api.getStatementResult)(request.buildAwsValue())
      .map(zio.aws.redshiftdata.model.GetStatementResultResponse.wrap)
      .provideEnvironment(r)
    def listSchemas(
        request: zio.aws.redshiftdata.model.ListSchemasRequest
    ): ZStream[Any, AwsError, String] = asyncSimplePaginatedRequest[
      ListSchemasRequest,
      ListSchemasResponse,
      java.lang.String
    ](
      "listSchemas",
      api.listSchemas,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.schemas().asScala)
    )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listSchemasPaginated(
        request: zio.aws.redshiftdata.model.ListSchemasRequest
    ): IO[AwsError, zio.aws.redshiftdata.model.ListSchemasResponse.ReadOnly] =
      asyncRequestResponse[ListSchemasRequest, ListSchemasResponse](
        "listSchemas",
        api.listSchemas
      )(request.buildAwsValue())
        .map(zio.aws.redshiftdata.model.ListSchemasResponse.wrap)
        .provideEnvironment(r)
    def describeStatement(
        request: zio.aws.redshiftdata.model.DescribeStatementRequest
    ): IO[
      AwsError,
      zio.aws.redshiftdata.model.DescribeStatementResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribeStatementRequest, DescribeStatementResponse](
        "describeStatement",
        api.describeStatement
      )(request.buildAwsValue())
        .map(zio.aws.redshiftdata.model.DescribeStatementResponse.wrap)
        .provideEnvironment(r)
  }
  def listDatabases(
      request: zio.aws.redshiftdata.model.ListDatabasesRequest
  ): ZStream[zio.aws.redshiftdata.RedshiftData, AwsError, String] =
    ZStream.serviceWithStream(_.listDatabases(request))
  def listDatabasesPaginated(
      request: zio.aws.redshiftdata.model.ListDatabasesRequest
  ): ZIO[
    zio.aws.redshiftdata.RedshiftData,
    AwsError,
    zio.aws.redshiftdata.model.ListDatabasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatabasesPaginated(request))
  def batchExecuteStatement(
      request: zio.aws.redshiftdata.model.BatchExecuteStatementRequest
  ): ZIO[
    zio.aws.redshiftdata.RedshiftData,
    AwsError,
    zio.aws.redshiftdata.model.BatchExecuteStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchExecuteStatement(request))
  def executeStatement(
      request: zio.aws.redshiftdata.model.ExecuteStatementRequest
  ): ZIO[
    zio.aws.redshiftdata.RedshiftData,
    AwsError,
    zio.aws.redshiftdata.model.ExecuteStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.executeStatement(request))
  def listStatements(
      request: zio.aws.redshiftdata.model.ListStatementsRequest
  ): ZStream[
    zio.aws.redshiftdata.RedshiftData,
    AwsError,
    zio.aws.redshiftdata.model.StatementData.ReadOnly
  ] = ZStream.serviceWithStream(_.listStatements(request))
  def listStatementsPaginated(
      request: zio.aws.redshiftdata.model.ListStatementsRequest
  ): ZIO[
    zio.aws.redshiftdata.RedshiftData,
    AwsError,
    zio.aws.redshiftdata.model.ListStatementsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStatementsPaginated(request))
  def listTables(
      request: zio.aws.redshiftdata.model.ListTablesRequest
  ): ZStream[
    zio.aws.redshiftdata.RedshiftData,
    AwsError,
    zio.aws.redshiftdata.model.TableMember.ReadOnly
  ] = ZStream.serviceWithStream(_.listTables(request))
  def listTablesPaginated(
      request: zio.aws.redshiftdata.model.ListTablesRequest
  ): ZIO[zio.aws.redshiftdata.RedshiftData, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listTablesPaginated(request))
  def describeTable(
      request: zio.aws.redshiftdata.model.DescribeTableRequest
  ): ZIO[zio.aws.redshiftdata.RedshiftData, AwsError, StreamingOutputResult[
    Any,
    zio.aws.redshiftdata.model.DescribeTableResponse.ReadOnly,
    zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeTable(request))
  def describeTablePaginated(
      request: zio.aws.redshiftdata.model.DescribeTableRequest
  ): ZIO[
    zio.aws.redshiftdata.RedshiftData,
    AwsError,
    zio.aws.redshiftdata.model.DescribeTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTablePaginated(request))
  def cancelStatement(
      request: zio.aws.redshiftdata.model.CancelStatementRequest
  ): ZIO[
    zio.aws.redshiftdata.RedshiftData,
    AwsError,
    zio.aws.redshiftdata.model.CancelStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelStatement(request))
  def getStatementResult(
      request: zio.aws.redshiftdata.model.GetStatementResultRequest
  ): ZStream[zio.aws.redshiftdata.RedshiftData, AwsError, List[
    zio.aws.redshiftdata.model.Field.ReadOnly
  ]] = ZStream.serviceWithStream(_.getStatementResult(request))
  def getStatementResultPaginated(
      request: zio.aws.redshiftdata.model.GetStatementResultRequest
  ): ZIO[
    zio.aws.redshiftdata.RedshiftData,
    AwsError,
    zio.aws.redshiftdata.model.GetStatementResultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStatementResultPaginated(request))
  def listSchemas(
      request: zio.aws.redshiftdata.model.ListSchemasRequest
  ): ZStream[zio.aws.redshiftdata.RedshiftData, AwsError, String] =
    ZStream.serviceWithStream(_.listSchemas(request))
  def listSchemasPaginated(
      request: zio.aws.redshiftdata.model.ListSchemasRequest
  ): ZIO[
    zio.aws.redshiftdata.RedshiftData,
    AwsError,
    zio.aws.redshiftdata.model.ListSchemasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSchemasPaginated(request))
  def describeStatement(
      request: zio.aws.redshiftdata.model.DescribeStatementRequest
  ): ZIO[
    zio.aws.redshiftdata.RedshiftData,
    AwsError,
    zio.aws.redshiftdata.model.DescribeStatementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStatement(request))
}
