package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.StatementId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStatementResultRequest(
    id: StatementId,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest = {
    import GetStatementResultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest
      .builder()
      .id(StatementId.unwrap(id): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftdata.model.GetStatementResultRequest.ReadOnly =
    zio.aws.redshiftdata.model.GetStatementResultRequest.wrap(buildAwsValue())
}
object GetStatementResultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.GetStatementResultRequest =
      zio.aws.redshiftdata.model
        .GetStatementResultRequest(id, nextToken.map(value => value))
    def id: StatementId
    def nextToken: Optional[String]
    def getId: ZIO[Any, Nothing, StatementId] = ZIO.succeed(id)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest
  ) extends zio.aws.redshiftdata.model.GetStatementResultRequest.ReadOnly {
    override val id: StatementId =
      zio.aws.redshiftdata.model.primitives.StatementId(impl.id())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest
  ): zio.aws.redshiftdata.model.GetStatementResultRequest.ReadOnly =
    new Wrapper(impl)
}
