package zio.aws.redshiftdata.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftdata.model.primitives.{
  SecretArn,
  StatementString,
  StatementId,
  Timestamp
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeStatementResponse(
    clusterIdentifier: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    database: Optional[String] = Optional.Absent,
    dbUser: Optional[String] = Optional.Absent,
    duration: Optional[Long] = Optional.Absent,
    error: Optional[String] = Optional.Absent,
    hasResultSet: Optional[Boolean] = Optional.Absent,
    id: StatementId,
    queryParameters: Optional[
      Iterable[zio.aws.redshiftdata.model.SqlParameter]
    ] = Optional.Absent,
    queryString: Optional[StatementString] = Optional.Absent,
    redshiftPid: Optional[Long] = Optional.Absent,
    redshiftQueryId: Optional[Long] = Optional.Absent,
    resultRows: Optional[Long] = Optional.Absent,
    resultSize: Optional[Long] = Optional.Absent,
    secretArn: Optional[SecretArn] = Optional.Absent,
    status: Optional[zio.aws.redshiftdata.model.StatusString] = Optional.Absent,
    subStatements: Optional[
      Iterable[zio.aws.redshiftdata.model.SubStatementData]
    ] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse = {
    import DescribeStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(database.map(value => value: java.lang.String))(
        _.database
      )
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(duration.map(value => value: java.lang.Long))(_.duration)
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .optionallyWith(hasResultSet.map(value => value: java.lang.Boolean))(
        _.hasResultSet
      )
      .id(StatementId.unwrap(id): java.lang.String)
      .optionallyWith(
        queryParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queryParameters)
      .optionallyWith(
        queryString.map(value =>
          StatementString.unwrap(value): java.lang.String
        )
      )(_.queryString)
      .optionallyWith(redshiftPid.map(value => value: java.lang.Long))(
        _.redshiftPid
      )
      .optionallyWith(redshiftQueryId.map(value => value: java.lang.Long))(
        _.redshiftQueryId
      )
      .optionallyWith(resultRows.map(value => value: java.lang.Long))(
        _.resultRows
      )
      .optionallyWith(resultSize.map(value => value: java.lang.Long))(
        _.resultSize
      )
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        subStatements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subStatements)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftdata.model.DescribeStatementResponse.ReadOnly =
    zio.aws.redshiftdata.model.DescribeStatementResponse.wrap(buildAwsValue())
}
object DescribeStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.DescribeStatementResponse =
      zio.aws.redshiftdata.model.DescribeStatementResponse(
        clusterIdentifier.map(value => value),
        createdAt.map(value => value),
        database.map(value => value),
        dbUser.map(value => value),
        duration.map(value => value),
        error.map(value => value),
        hasResultSet.map(value => value),
        id,
        queryParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        queryString.map(value => value),
        redshiftPid.map(value => value),
        redshiftQueryId.map(value => value),
        resultRows.map(value => value),
        resultSize.map(value => value),
        secretArn.map(value => value),
        status.map(value => value),
        subStatements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updatedAt.map(value => value)
      )
    def clusterIdentifier: Optional[String]
    def createdAt: Optional[Timestamp]
    def database: Optional[String]
    def dbUser: Optional[String]
    def duration: Optional[Long]
    def error: Optional[String]
    def hasResultSet: Optional[Boolean]
    def id: StatementId
    def queryParameters
        : Optional[List[zio.aws.redshiftdata.model.SqlParameter.ReadOnly]]
    def queryString: Optional[StatementString]
    def redshiftPid: Optional[Long]
    def redshiftQueryId: Optional[Long]
    def resultRows: Optional[Long]
    def resultSize: Optional[Long]
    def secretArn: Optional[SecretArn]
    def status: Optional[zio.aws.redshiftdata.model.StatusString]
    def subStatements
        : Optional[List[zio.aws.redshiftdata.model.SubStatementData.ReadOnly]]
    def updatedAt: Optional[Timestamp]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDatabase: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("database", database)
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getDuration: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("duration", duration)
    def getError: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("error", error)
    def getHasResultSet: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hasResultSet", hasResultSet)
    def getId: ZIO[Any, Nothing, StatementId] = ZIO.succeed(id)
    def getQueryParameters: ZIO[Any, AwsError, List[
      zio.aws.redshiftdata.model.SqlParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("queryParameters", queryParameters)
    def getQueryString: ZIO[Any, AwsError, StatementString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getRedshiftPid: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("redshiftPid", redshiftPid)
    def getRedshiftQueryId: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("redshiftQueryId", redshiftQueryId)
    def getResultRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("resultRows", resultRows)
    def getResultSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("resultSize", resultSize)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.redshiftdata.model.StatusString] =
      AwsError.unwrapOptionField("status", status)
    def getSubStatements: ZIO[Any, AwsError, List[
      zio.aws.redshiftdata.model.SubStatementData.ReadOnly
    ]] = AwsError.unwrapOptionField("subStatements", subStatements)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse
  ) extends zio.aws.redshiftdata.model.DescribeStatementResponse.ReadOnly {
    override val clusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
    override val database: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.database())
      .map(value => value: String)
    override val dbUser: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbUser())
      .map(value => value: String)
    override val duration: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Long)
    override val error: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => value: String)
    override val hasResultSet: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasResultSet())
      .map(value => value: Boolean)
    override val id: StatementId =
      zio.aws.redshiftdata.model.primitives.StatementId(impl.id())
    override val queryParameters
        : Optional[List[zio.aws.redshiftdata.model.SqlParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftdata.model.SqlParameter.wrap(item)
          }.toList
        )
    override val queryString: Optional[StatementString] = zio.aws.core.internal
      .optionalFromNullable(impl.queryString())
      .map(value =>
        zio.aws.redshiftdata.model.primitives.StatementString(value)
      )
    override val redshiftPid: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.redshiftPid())
      .map(value => value: Long)
    override val redshiftQueryId: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.redshiftQueryId())
      .map(value => value: Long)
    override val resultRows: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.resultRows())
      .map(value => value: Long)
    override val resultSize: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.resultSize())
      .map(value => value: Long)
    override val secretArn: Optional[SecretArn] = zio.aws.core.internal
      .optionalFromNullable(impl.secretArn())
      .map(value => zio.aws.redshiftdata.model.primitives.SecretArn(value))
    override val status: Optional[zio.aws.redshiftdata.model.StatusString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.redshiftdata.model.StatusString.wrap(value))
    override val subStatements
        : Optional[List[zio.aws.redshiftdata.model.SubStatementData.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subStatements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftdata.model.SubStatementData.wrap(item)
          }.toList
        )
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse
  ): zio.aws.redshiftdata.model.DescribeStatementResponse.ReadOnly =
    new Wrapper(impl)
}
