package zio.aws.redshiftdata.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftdata.model.primitives.{
  StatementString,
  StatementId,
  Timestamp
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SubStatementData(
    createdAt: Optional[Timestamp] = Optional.Absent,
    duration: Optional[Long] = Optional.Absent,
    error: Optional[String] = Optional.Absent,
    hasResultSet: Optional[Boolean] = Optional.Absent,
    id: StatementId,
    queryString: Optional[StatementString] = Optional.Absent,
    redshiftQueryId: Optional[Long] = Optional.Absent,
    resultRows: Optional[Long] = Optional.Absent,
    resultSize: Optional[Long] = Optional.Absent,
    status: Optional[zio.aws.redshiftdata.model.StatementStatusString] =
      Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.SubStatementData = {
    import SubStatementData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.SubStatementData
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(duration.map(value => value: java.lang.Long))(_.duration)
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .optionallyWith(hasResultSet.map(value => value: java.lang.Boolean))(
        _.hasResultSet
      )
      .id(StatementId.unwrap(id): java.lang.String)
      .optionallyWith(
        queryString.map(value =>
          StatementString.unwrap(value): java.lang.String
        )
      )(_.queryString)
      .optionallyWith(redshiftQueryId.map(value => value: java.lang.Long))(
        _.redshiftQueryId
      )
      .optionallyWith(resultRows.map(value => value: java.lang.Long))(
        _.resultRows
      )
      .optionallyWith(resultSize.map(value => value: java.lang.Long))(
        _.resultSize
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.SubStatementData.ReadOnly =
    zio.aws.redshiftdata.model.SubStatementData.wrap(buildAwsValue())
}
object SubStatementData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.SubStatementData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.SubStatementData =
      zio.aws.redshiftdata.model.SubStatementData(
        createdAt.map(value => value),
        duration.map(value => value),
        error.map(value => value),
        hasResultSet.map(value => value),
        id,
        queryString.map(value => value),
        redshiftQueryId.map(value => value),
        resultRows.map(value => value),
        resultSize.map(value => value),
        status.map(value => value),
        updatedAt.map(value => value)
      )
    def createdAt: Optional[Timestamp]
    def duration: Optional[Long]
    def error: Optional[String]
    def hasResultSet: Optional[Boolean]
    def id: StatementId
    def queryString: Optional[StatementString]
    def redshiftQueryId: Optional[Long]
    def resultRows: Optional[Long]
    def resultSize: Optional[Long]
    def status: Optional[zio.aws.redshiftdata.model.StatementStatusString]
    def updatedAt: Optional[Timestamp]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDuration: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("duration", duration)
    def getError: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("error", error)
    def getHasResultSet: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hasResultSet", hasResultSet)
    def getId: ZIO[Any, Nothing, StatementId] = ZIO.succeed(id)
    def getQueryString: ZIO[Any, AwsError, StatementString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getRedshiftQueryId: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("redshiftQueryId", redshiftQueryId)
    def getResultRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("resultRows", resultRows)
    def getResultSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("resultSize", resultSize)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.redshiftdata.model.StatementStatusString] =
      AwsError.unwrapOptionField("status", status)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.SubStatementData
  ) extends zio.aws.redshiftdata.model.SubStatementData.ReadOnly {
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
    override val duration: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Long)
    override val error: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => value: String)
    override val hasResultSet: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasResultSet())
      .map(value => value: Boolean)
    override val id: StatementId =
      zio.aws.redshiftdata.model.primitives.StatementId(impl.id())
    override val queryString: Optional[StatementString] = zio.aws.core.internal
      .optionalFromNullable(impl.queryString())
      .map(value =>
        zio.aws.redshiftdata.model.primitives.StatementString(value)
      )
    override val redshiftQueryId: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.redshiftQueryId())
      .map(value => value: Long)
    override val resultRows: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.resultRows())
      .map(value => value: Long)
    override val resultSize: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.resultSize())
      .map(value => value: Long)
    override val status
        : Optional[zio.aws.redshiftdata.model.StatementStatusString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.redshiftdata.model.StatementStatusString.wrap(value)
        )
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.SubStatementData
  ): zio.aws.redshiftdata.model.SubStatementData.ReadOnly = new Wrapper(impl)
}
