package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{Integer, Bool}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ColumnMetadata(
    columnDefault: Optional[String] = Optional.Absent,
    isCaseSensitive: Optional[Bool] = Optional.Absent,
    isCurrency: Optional[Bool] = Optional.Absent,
    isSigned: Optional[Bool] = Optional.Absent,
    label: Optional[String] = Optional.Absent,
    length: Optional[Integer] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    nullable: Optional[Integer] = Optional.Absent,
    precision: Optional[Integer] = Optional.Absent,
    scale: Optional[Integer] = Optional.Absent,
    schemaName: Optional[String] = Optional.Absent,
    tableName: Optional[String] = Optional.Absent,
    typeName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata = {
    import ColumnMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata
      .builder()
      .optionallyWith(columnDefault.map(value => value: java.lang.String))(
        _.columnDefault
      )
      .optionallyWith(isCaseSensitive.map(value => value: java.lang.Boolean))(
        _.isCaseSensitive
      )
      .optionallyWith(isCurrency.map(value => value: java.lang.Boolean))(
        _.isCurrency
      )
      .optionallyWith(isSigned.map(value => value: java.lang.Boolean))(
        _.isSigned
      )
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .optionallyWith(length.map(value => value: java.lang.Integer))(_.length)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(nullable.map(value => value: java.lang.Integer))(
        _.nullable
      )
      .optionallyWith(precision.map(value => value: java.lang.Integer))(
        _.precision
      )
      .optionallyWith(scale.map(value => value: java.lang.Integer))(_.scale)
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(tableName.map(value => value: java.lang.String))(
        _.tableName
      )
      .optionallyWith(typeName.map(value => value: java.lang.String))(
        _.typeName
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly =
    zio.aws.redshiftdata.model.ColumnMetadata.wrap(buildAwsValue())
}
object ColumnMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.ColumnMetadata =
      zio.aws.redshiftdata.model.ColumnMetadata(
        columnDefault.map(value => value),
        isCaseSensitive.map(value => value),
        isCurrency.map(value => value),
        isSigned.map(value => value),
        label.map(value => value),
        length.map(value => value),
        name.map(value => value),
        nullable.map(value => value),
        precision.map(value => value),
        scale.map(value => value),
        schemaName.map(value => value),
        tableName.map(value => value),
        typeName.map(value => value)
      )
    def columnDefault: Optional[String]
    def isCaseSensitive: Optional[Bool]
    def isCurrency: Optional[Bool]
    def isSigned: Optional[Bool]
    def label: Optional[String]
    def length: Optional[Integer]
    def name: Optional[String]
    def nullable: Optional[Integer]
    def precision: Optional[Integer]
    def scale: Optional[Integer]
    def schemaName: Optional[String]
    def tableName: Optional[String]
    def typeName: Optional[String]
    def getColumnDefault: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("columnDefault", columnDefault)
    def getIsCaseSensitive: ZIO[Any, AwsError, Bool] =
      AwsError.unwrapOptionField("isCaseSensitive", isCaseSensitive)
    def getIsCurrency: ZIO[Any, AwsError, Bool] =
      AwsError.unwrapOptionField("isCurrency", isCurrency)
    def getIsSigned: ZIO[Any, AwsError, Bool] =
      AwsError.unwrapOptionField("isSigned", isSigned)
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
    def getLength: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("length", length)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getNullable: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nullable", nullable)
    def getPrecision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("precision", precision)
    def getScale: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scale", scale)
    def getSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getTypeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("typeName", typeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata
  ) extends zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly {
    override val columnDefault: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.columnDefault())
      .map(value => value: String)
    override val isCaseSensitive: Optional[Bool] = zio.aws.core.internal
      .optionalFromNullable(impl.isCaseSensitive())
      .map(value => value: Bool)
    override val isCurrency: Optional[Bool] = zio.aws.core.internal
      .optionalFromNullable(impl.isCurrency())
      .map(value => value: Bool)
    override val isSigned: Optional[Bool] = zio.aws.core.internal
      .optionalFromNullable(impl.isSigned())
      .map(value => value: Bool)
    override val label: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => value: String)
    override val length: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.length())
      .map(value => value: Integer)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val nullable: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.nullable())
      .map(value => value: Integer)
    override val precision: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.precision())
      .map(value => value: Integer)
    override val scale: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.scale())
      .map(value => value: Integer)
    override val schemaName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaName())
      .map(value => value: String)
    override val tableName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => value: String)
    override val typeName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata
  ): zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly = new Wrapper(impl)
}
