package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.StatementId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelStatementRequest(id: StatementId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.CancelStatementRequest = {
    import CancelStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.CancelStatementRequest
      .builder()
      .id(StatementId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.CancelStatementRequest.ReadOnly =
    zio.aws.redshiftdata.model.CancelStatementRequest.wrap(buildAwsValue())
}
object CancelStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.CancelStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.CancelStatementRequest =
      zio.aws.redshiftdata.model.CancelStatementRequest(id)
    def id: StatementId
    def getId: ZIO[Any, Nothing, StatementId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.CancelStatementRequest
  ) extends zio.aws.redshiftdata.model.CancelStatementRequest.ReadOnly {
    override val id: StatementId =
      zio.aws.redshiftdata.model.primitives.StatementId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.CancelStatementRequest
  ): zio.aws.redshiftdata.model.CancelStatementRequest.ReadOnly = new Wrapper(
    impl
  )
}
