package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{
  StatementNameString,
  StatementString,
  SecretArn,
  Location
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchExecuteStatementRequest(
    clusterIdentifier: Option[Location] = None,
    database: String,
    dbUser: Option[String] = None,
    secretArn: Option[SecretArn] = None,
    sqls: Iterable[StatementString],
    statementName: Option[StatementNameString] = None,
    withEvent: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementRequest = {
    import BatchExecuteStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementRequest
      .builder()
      .optionallyWith(
        clusterIdentifier.map(value => Location.unwrap(value): java.lang.String)
      )(_.clusterIdentifier)
      .database(database: java.lang.String)
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .sqls(sqls.map { item =>
        StatementString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        statementName.map(value =>
          StatementNameString.unwrap(value): java.lang.String
        )
      )(_.statementName)
      .optionallyWith(withEvent.map(value => value: java.lang.Boolean))(
        _.withEvent
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftdata.model.BatchExecuteStatementRequest.ReadOnly =
    zio.aws.redshiftdata.model.BatchExecuteStatementRequest
      .wrap(buildAwsValue())
}
object BatchExecuteStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.BatchExecuteStatementRequest =
      zio.aws.redshiftdata.model.BatchExecuteStatementRequest(
        clusterIdentifier.map(value => value),
        database,
        dbUser.map(value => value),
        secretArn.map(value => value),
        sqls,
        statementName.map(value => value),
        withEvent.map(value => value)
      )
    def clusterIdentifier: Option[Location]
    def database: String
    def dbUser: Option[String]
    def secretArn: Option[SecretArn]
    def sqls: List[StatementString]
    def statementName: Option[StatementNameString]
    def withEvent: Option[Boolean]
    def getClusterIdentifier: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getDatabase: ZIO[Any, Nothing, String] = ZIO.succeed(database)
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getSqls: ZIO[Any, Nothing, List[StatementString]] = ZIO.succeed(sqls)
    def getStatementName: ZIO[Any, AwsError, StatementNameString] =
      AwsError.unwrapOptionField("statementName", statementName)
    def getWithEvent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("withEvent", withEvent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementRequest
  ) extends zio.aws.redshiftdata.model.BatchExecuteStatementRequest.ReadOnly {
    override val clusterIdentifier: Option[Location] = scala
      .Option(impl.clusterIdentifier())
      .map(value => zio.aws.redshiftdata.model.primitives.Location(value))
    override val database: String = impl.database(): String
    override val dbUser: Option[String] =
      scala.Option(impl.dbUser()).map(value => value: String)
    override val secretArn: Option[SecretArn] = scala
      .Option(impl.secretArn())
      .map(value => zio.aws.redshiftdata.model.primitives.SecretArn(value))
    override val sqls: List[StatementString] = impl
      .sqls()
      .asScala
      .map { item =>
        zio.aws.redshiftdata.model.primitives.StatementString(item)
      }
      .toList
    override val statementName: Option[StatementNameString] = scala
      .Option(impl.statementName())
      .map(value =>
        zio.aws.redshiftdata.model.primitives.StatementNameString(value)
      )
    override val withEvent: Option[Boolean] =
      scala.Option(impl.withEvent()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementRequest
  ): zio.aws.redshiftdata.model.BatchExecuteStatementRequest.ReadOnly =
    new Wrapper(impl)
}
