package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{Integer, Bool}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ColumnMetadata(
    columnDefault: Option[String] = None,
    isCaseSensitive: Option[Bool] = None,
    isCurrency: Option[Bool] = None,
    isSigned: Option[Bool] = None,
    label: Option[String] = None,
    length: Option[Integer] = None,
    name: Option[String] = None,
    nullable: Option[Integer] = None,
    precision: Option[Integer] = None,
    scale: Option[Integer] = None,
    schemaName: Option[String] = None,
    tableName: Option[String] = None,
    typeName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata = {
    import ColumnMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata
      .builder()
      .optionallyWith(columnDefault.map(value => value: java.lang.String))(
        _.columnDefault
      )
      .optionallyWith(
        isCaseSensitive.map(value => Bool.unwrap(value): java.lang.Boolean)
      )(_.isCaseSensitive)
      .optionallyWith(
        isCurrency.map(value => Bool.unwrap(value): java.lang.Boolean)
      )(_.isCurrency)
      .optionallyWith(
        isSigned.map(value => Bool.unwrap(value): java.lang.Boolean)
      )(_.isSigned)
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .optionallyWith(
        length.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.length)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        nullable.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.nullable)
      .optionallyWith(
        precision.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.precision)
      .optionallyWith(
        scale.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.scale)
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(tableName.map(value => value: java.lang.String))(
        _.tableName
      )
      .optionallyWith(typeName.map(value => value: java.lang.String))(
        _.typeName
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly =
    zio.aws.redshiftdata.model.ColumnMetadata.wrap(buildAwsValue())
}
object ColumnMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.ColumnMetadata =
      zio.aws.redshiftdata.model.ColumnMetadata(
        columnDefault.map(value => value),
        isCaseSensitive.map(value => value),
        isCurrency.map(value => value),
        isSigned.map(value => value),
        label.map(value => value),
        length.map(value => value),
        name.map(value => value),
        nullable.map(value => value),
        precision.map(value => value),
        scale.map(value => value),
        schemaName.map(value => value),
        tableName.map(value => value),
        typeName.map(value => value)
      )
    def columnDefault: Option[String]
    def isCaseSensitive: Option[Bool]
    def isCurrency: Option[Bool]
    def isSigned: Option[Bool]
    def label: Option[String]
    def length: Option[Integer]
    def name: Option[String]
    def nullable: Option[Integer]
    def precision: Option[Integer]
    def scale: Option[Integer]
    def schemaName: Option[String]
    def tableName: Option[String]
    def typeName: Option[String]
    def getColumnDefault: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("columnDefault", columnDefault)
    def getIsCaseSensitive: ZIO[Any, AwsError, Bool] =
      AwsError.unwrapOptionField("isCaseSensitive", isCaseSensitive)
    def getIsCurrency: ZIO[Any, AwsError, Bool] =
      AwsError.unwrapOptionField("isCurrency", isCurrency)
    def getIsSigned: ZIO[Any, AwsError, Bool] =
      AwsError.unwrapOptionField("isSigned", isSigned)
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
    def getLength: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("length", length)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getNullable: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nullable", nullable)
    def getPrecision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("precision", precision)
    def getScale: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scale", scale)
    def getSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getTypeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("typeName", typeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata
  ) extends zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly {
    override val columnDefault: Option[String] =
      scala.Option(impl.columnDefault()).map(value => value: String)
    override val isCaseSensitive: Option[Bool] = scala
      .Option(impl.isCaseSensitive())
      .map(value => zio.aws.redshiftdata.model.primitives.Bool(value))
    override val isCurrency: Option[Bool] = scala
      .Option(impl.isCurrency())
      .map(value => zio.aws.redshiftdata.model.primitives.Bool(value))
    override val isSigned: Option[Bool] = scala
      .Option(impl.isSigned())
      .map(value => zio.aws.redshiftdata.model.primitives.Bool(value))
    override val label: Option[String] =
      scala.Option(impl.label()).map(value => value: String)
    override val length: Option[Integer] = scala
      .Option(impl.length())
      .map(value => zio.aws.redshiftdata.model.primitives.Integer(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val nullable: Option[Integer] = scala
      .Option(impl.nullable())
      .map(value => zio.aws.redshiftdata.model.primitives.Integer(value))
    override val precision: Option[Integer] = scala
      .Option(impl.precision())
      .map(value => zio.aws.redshiftdata.model.primitives.Integer(value))
    override val scale: Option[Integer] = scala
      .Option(impl.scale())
      .map(value => zio.aws.redshiftdata.model.primitives.Integer(value))
    override val schemaName: Option[String] =
      scala.Option(impl.schemaName()).map(value => value: String)
    override val tableName: Option[String] =
      scala.Option(impl.tableName()).map(value => value: String)
    override val typeName: Option[String] =
      scala.Option(impl.typeName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata
  ): zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly = new Wrapper(impl)
}
