package zio.aws.redshiftdata.model
import java.lang.Integer
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{SecretArn, PageSize, Location}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTableRequest(
    clusterIdentifier: Option[Location] = None,
    connectedDatabase: Option[String] = None,
    database: String,
    dbUser: Option[String] = None,
    maxResults: Option[PageSize] = None,
    nextToken: Option[String] = None,
    schema: Option[String] = None,
    secretArn: Option[SecretArn] = None,
    table: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest = {
    import DescribeTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest
      .builder()
      .optionallyWith(
        clusterIdentifier.map(value => Location.unwrap(value): java.lang.String)
      )(_.clusterIdentifier)
      .optionallyWith(connectedDatabase.map(value => value: java.lang.String))(
        _.connectedDatabase
      )
      .database(database: java.lang.String)
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(schema.map(value => value: java.lang.String))(_.schema)
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .optionallyWith(table.map(value => value: java.lang.String))(_.table)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.DescribeTableRequest.ReadOnly =
    zio.aws.redshiftdata.model.DescribeTableRequest.wrap(buildAwsValue())
}
object DescribeTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.DescribeTableRequest =
      zio.aws.redshiftdata.model.DescribeTableRequest(
        clusterIdentifier.map(value => value),
        connectedDatabase.map(value => value),
        database,
        dbUser.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        schema.map(value => value),
        secretArn.map(value => value),
        table.map(value => value)
      )
    def clusterIdentifier: Option[Location]
    def connectedDatabase: Option[String]
    def database: String
    def dbUser: Option[String]
    def maxResults: Option[PageSize]
    def nextToken: Option[String]
    def schema: Option[String]
    def secretArn: Option[SecretArn]
    def table: Option[String]
    def getClusterIdentifier: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getConnectedDatabase: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectedDatabase", connectedDatabase)
    def getDatabase: ZIO[Any, Nothing, String] = ZIO.succeed(database)
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSchema: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schema", schema)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getTable: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("table", table)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest
  ) extends zio.aws.redshiftdata.model.DescribeTableRequest.ReadOnly {
    override val clusterIdentifier: Option[Location] = scala
      .Option(impl.clusterIdentifier())
      .map(value => zio.aws.redshiftdata.model.primitives.Location(value))
    override val connectedDatabase: Option[String] =
      scala.Option(impl.connectedDatabase()).map(value => value: String)
    override val database: String = impl.database(): String
    override val dbUser: Option[String] =
      scala.Option(impl.dbUser()).map(value => value: String)
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.redshiftdata.model.primitives.PageSize(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val schema: Option[String] =
      scala.Option(impl.schema()).map(value => value: String)
    override val secretArn: Option[SecretArn] = scala
      .Option(impl.secretArn())
      .map(value => zio.aws.redshiftdata.model.primitives.SecretArn(value))
    override val table: Option[String] =
      scala.Option(impl.table()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest
  ): zio.aws.redshiftdata.model.DescribeTableRequest.ReadOnly = new Wrapper(
    impl
  )
}
