package zio.aws.redshiftdata.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftdata.model.primitives.{
  StatementNameString,
  ListStatementsLimit
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStatementsRequest(
    maxResults: Optional[ListStatementsLimit] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    roleLevel: Optional[Boolean] = Optional.Absent,
    statementName: Optional[StatementNameString] = Optional.Absent,
    status: Optional[zio.aws.redshiftdata.model.StatusString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest = {
    import ListStatementsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => ListStatementsLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(roleLevel.map(value => value: java.lang.Boolean))(
        _.roleLevel
      )
      .optionallyWith(
        statementName.map(value =>
          StatementNameString.unwrap(value): java.lang.String
        )
      )(_.statementName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.ListStatementsRequest.ReadOnly =
    zio.aws.redshiftdata.model.ListStatementsRequest.wrap(buildAwsValue())
}
object ListStatementsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.ListStatementsRequest =
      zio.aws.redshiftdata.model.ListStatementsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        roleLevel.map(value => value),
        statementName.map(value => value),
        status.map(value => value)
      )
    def maxResults: Optional[ListStatementsLimit]
    def nextToken: Optional[String]
    def roleLevel: Optional[Boolean]
    def statementName: Optional[StatementNameString]
    def status: Optional[zio.aws.redshiftdata.model.StatusString]
    def getMaxResults: ZIO[Any, AwsError, ListStatementsLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRoleLevel: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("roleLevel", roleLevel)
    def getStatementName: ZIO[Any, AwsError, StatementNameString] =
      AwsError.unwrapOptionField("statementName", statementName)
    def getStatus: ZIO[Any, AwsError, zio.aws.redshiftdata.model.StatusString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest
  ) extends zio.aws.redshiftdata.model.ListStatementsRequest.ReadOnly {
    override val maxResults: Optional[ListStatementsLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.redshiftdata.model.primitives.ListStatementsLimit(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val roleLevel: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.roleLevel())
      .map(value => value: Boolean)
    override val statementName: Optional[StatementNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statementName())
        .map(value =>
          zio.aws.redshiftdata.model.primitives.StatementNameString(value)
        )
    override val status: Optional[zio.aws.redshiftdata.model.StatusString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.redshiftdata.model.StatusString.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest
  ): zio.aws.redshiftdata.model.ListStatementsRequest.ReadOnly = new Wrapper(
    impl
  )
}
