package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStatementsResponse(
    nextToken: Optional[String] = Optional.Absent,
    statements: Iterable[zio.aws.redshiftdata.model.StatementData]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse = {
    import ListStatementsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .statements(statements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.ListStatementsResponse.ReadOnly =
    zio.aws.redshiftdata.model.ListStatementsResponse.wrap(buildAwsValue())
}
object ListStatementsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.ListStatementsResponse =
      zio.aws.redshiftdata.model.ListStatementsResponse(
        nextToken.map(value => value),
        statements.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def statements: List[zio.aws.redshiftdata.model.StatementData.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStatements: ZIO[Any, Nothing, List[
      zio.aws.redshiftdata.model.StatementData.ReadOnly
    ]] = ZIO.succeed(statements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse
  ) extends zio.aws.redshiftdata.model.ListStatementsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val statements
        : List[zio.aws.redshiftdata.model.StatementData.ReadOnly] = impl
      .statements()
      .asScala
      .map { item =>
        zio.aws.redshiftdata.model.StatementData.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse
  ): zio.aws.redshiftdata.model.ListStatementsResponse.ReadOnly = new Wrapper(
    impl
  )
}
