package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelStatementResponse(
    status: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.CancelStatementResponse = {
    import CancelStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.CancelStatementResponse
      .builder()
      .optionallyWith(status.map(value => value: java.lang.Boolean))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.CancelStatementResponse.ReadOnly =
    zio.aws.redshiftdata.model.CancelStatementResponse.wrap(buildAwsValue())
}
object CancelStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.CancelStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.CancelStatementResponse =
      zio.aws.redshiftdata.model
        .CancelStatementResponse(status.map(value => value))
    def status: Optional[Boolean]
    def getStatus: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.CancelStatementResponse
  ) extends zio.aws.redshiftdata.model.CancelStatementResponse.ReadOnly {
    override val status: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.CancelStatementResponse
  ): zio.aws.redshiftdata.model.CancelStatementResponse.ReadOnly = new Wrapper(
    impl
  )
}
