package zio.aws.redshiftdata.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftdata.model.primitives.{
  SecretArn,
  StatementId,
  Timestamp,
  Location
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class BatchExecuteStatementResponse(
    clusterIdentifier: Optional[Location] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    database: Optional[String] = Optional.Absent,
    dbUser: Optional[String] = Optional.Absent,
    id: Optional[StatementId] = Optional.Absent,
    secretArn: Optional[SecretArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementResponse = {
    import BatchExecuteStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementResponse
      .builder()
      .optionallyWith(
        clusterIdentifier.map(value => Location.unwrap(value): java.lang.String)
      )(_.clusterIdentifier)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(database.map(value => value: java.lang.String))(
        _.database
      )
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(
        id.map(value => StatementId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftdata.model.BatchExecuteStatementResponse.ReadOnly =
    zio.aws.redshiftdata.model.BatchExecuteStatementResponse
      .wrap(buildAwsValue())
}
object BatchExecuteStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.BatchExecuteStatementResponse =
      zio.aws.redshiftdata.model.BatchExecuteStatementResponse(
        clusterIdentifier.map(value => value),
        createdAt.map(value => value),
        database.map(value => value),
        dbUser.map(value => value),
        id.map(value => value),
        secretArn.map(value => value)
      )
    def clusterIdentifier: Optional[Location]
    def createdAt: Optional[Timestamp]
    def database: Optional[String]
    def dbUser: Optional[String]
    def id: Optional[StatementId]
    def secretArn: Optional[SecretArn]
    def getClusterIdentifier: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDatabase: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("database", database)
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getId: ZIO[Any, AwsError, StatementId] =
      AwsError.unwrapOptionField("id", id)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementResponse
  ) extends zio.aws.redshiftdata.model.BatchExecuteStatementResponse.ReadOnly {
    override val clusterIdentifier: Optional[Location] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => zio.aws.redshiftdata.model.primitives.Location(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
    override val database: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.database())
      .map(value => value: String)
    override val dbUser: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbUser())
      .map(value => value: String)
    override val id: Optional[StatementId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.redshiftdata.model.primitives.StatementId(value))
    override val secretArn: Optional[SecretArn] = zio.aws.core.internal
      .optionalFromNullable(impl.secretArn())
      .map(value => zio.aws.redshiftdata.model.primitives.SecretArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementResponse
  ): zio.aws.redshiftdata.model.BatchExecuteStatementResponse.ReadOnly =
    new Wrapper(impl)
}
