package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TableMember(
    name: Optional[String] = Optional.Absent,
    schema: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.TableMember = {
    import TableMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.TableMember
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(schema.map(value => value: java.lang.String))(_.schema)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.TableMember.ReadOnly =
    zio.aws.redshiftdata.model.TableMember.wrap(buildAwsValue())
}
object TableMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.TableMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.TableMember =
      zio.aws.redshiftdata.model.TableMember(
        name.map(value => value),
        schema.map(value => value),
        `type`.map(value => value)
      )
    def name: Optional[String]
    def schema: Optional[String]
    def `type`: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getSchema: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schema", schema)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.TableMember
  ) extends zio.aws.redshiftdata.model.TableMember.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val schema: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.TableMember
  ): zio.aws.redshiftdata.model.TableMember.ReadOnly = new Wrapper(impl)
}
