package zio.aws.redshiftdata.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftdata.model.primitives.{SecretArn, PageSize, Location}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSchemasRequest(
    clusterIdentifier: Optional[Location] = Optional.Absent,
    connectedDatabase: Optional[String] = Optional.Absent,
    database: String,
    dbUser: Optional[String] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    schemaPattern: Optional[String] = Optional.Absent,
    secretArn: Optional[SecretArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest = {
    import ListSchemasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest
      .builder()
      .optionallyWith(
        clusterIdentifier.map(value => Location.unwrap(value): java.lang.String)
      )(_.clusterIdentifier)
      .optionallyWith(connectedDatabase.map(value => value: java.lang.String))(
        _.connectedDatabase
      )
      .database(database: java.lang.String)
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(schemaPattern.map(value => value: java.lang.String))(
        _.schemaPattern
      )
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.ListSchemasRequest.ReadOnly =
    zio.aws.redshiftdata.model.ListSchemasRequest.wrap(buildAwsValue())
}
object ListSchemasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.ListSchemasRequest =
      zio.aws.redshiftdata.model.ListSchemasRequest(
        clusterIdentifier.map(value => value),
        connectedDatabase.map(value => value),
        database,
        dbUser.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        schemaPattern.map(value => value),
        secretArn.map(value => value)
      )
    def clusterIdentifier: Optional[Location]
    def connectedDatabase: Optional[String]
    def database: String
    def dbUser: Optional[String]
    def maxResults: Optional[PageSize]
    def nextToken: Optional[String]
    def schemaPattern: Optional[String]
    def secretArn: Optional[SecretArn]
    def getClusterIdentifier: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getConnectedDatabase: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectedDatabase", connectedDatabase)
    def getDatabase: ZIO[Any, Nothing, String] = ZIO.succeed(database)
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSchemaPattern: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaPattern", schemaPattern)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest
  ) extends zio.aws.redshiftdata.model.ListSchemasRequest.ReadOnly {
    override val clusterIdentifier: Optional[Location] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterIdentifier())
      .map(value => zio.aws.redshiftdata.model.primitives.Location(value))
    override val connectedDatabase: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectedDatabase())
      .map(value => value: String)
    override val database: String = impl.database(): String
    override val dbUser: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbUser())
      .map(value => value: String)
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.redshiftdata.model.primitives.PageSize(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val schemaPattern: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaPattern())
      .map(value => value: String)
    override val secretArn: Optional[SecretArn] = zio.aws.core.internal
      .optionalFromNullable(impl.secretArn())
      .map(value => zio.aws.redshiftdata.model.primitives.SecretArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest
  ): zio.aws.redshiftdata.model.ListSchemasRequest.ReadOnly = new Wrapper(impl)
}
