package zio.aws.redshiftdata
import zio.aws.redshiftdata.model.ListTablesResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.redshiftdata.RedshiftDataAsyncClient
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.aws.redshiftdata.model.{
  ExecuteStatementRequest,
  DescribeTableRequest,
  ListSchemasRequest,
  GetStatementResultRequest,
  ListDatabasesRequest,
  DescribeStatementRequest,
  ListStatementsRequest,
  BatchExecuteStatementRequest,
  CancelStatementRequest,
  ListTablesRequest
}
import zio.stream.ZStream
object RedshiftDataMock extends Mock[RedshiftData] {
  object ListDatabases extends Stream[ListDatabasesRequest, AwsError, String]
  object ListDatabasesPaginated
      extends Effect[
        ListDatabasesRequest,
        AwsError,
        zio.aws.redshiftdata.model.ListDatabasesResponse.ReadOnly
      ]
  object BatchExecuteStatement
      extends Effect[
        BatchExecuteStatementRequest,
        AwsError,
        zio.aws.redshiftdata.model.BatchExecuteStatementResponse.ReadOnly
      ]
  object ExecuteStatement
      extends Effect[
        ExecuteStatementRequest,
        AwsError,
        zio.aws.redshiftdata.model.ExecuteStatementResponse.ReadOnly
      ]
  object ListStatements
      extends Stream[
        ListStatementsRequest,
        AwsError,
        zio.aws.redshiftdata.model.StatementData.ReadOnly
      ]
  object ListStatementsPaginated
      extends Effect[
        ListStatementsRequest,
        AwsError,
        zio.aws.redshiftdata.model.ListStatementsResponse.ReadOnly
      ]
  object ListTables
      extends Stream[
        ListTablesRequest,
        AwsError,
        zio.aws.redshiftdata.model.TableMember.ReadOnly
      ]
  object ListTablesPaginated
      extends Effect[ListTablesRequest, AwsError, ReadOnly]
  object DescribeTable
      extends Effect[DescribeTableRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.redshiftdata.model.DescribeTableResponse.ReadOnly,
        zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly
      ]]
  object DescribeTablePaginated
      extends Effect[
        DescribeTableRequest,
        AwsError,
        zio.aws.redshiftdata.model.DescribeTableResponse.ReadOnly
      ]
  object CancelStatement
      extends Effect[
        CancelStatementRequest,
        AwsError,
        zio.aws.redshiftdata.model.CancelStatementResponse.ReadOnly
      ]
  object GetStatementResult
      extends Stream[GetStatementResultRequest, AwsError, List[
        zio.aws.redshiftdata.model.Field.ReadOnly
      ]]
  object GetStatementResultPaginated
      extends Effect[
        GetStatementResultRequest,
        AwsError,
        zio.aws.redshiftdata.model.GetStatementResultResponse.ReadOnly
      ]
  object ListSchemas extends Stream[ListSchemasRequest, AwsError, String]
  object ListSchemasPaginated
      extends Effect[
        ListSchemasRequest,
        AwsError,
        zio.aws.redshiftdata.model.ListSchemasResponse.ReadOnly
      ]
  object DescribeStatement
      extends Effect[
        DescribeStatementRequest,
        AwsError,
        zio.aws.redshiftdata.model.DescribeStatementResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, RedshiftData] = ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new RedshiftData {
          val api: RedshiftDataAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : RedshiftData = this
          def listDatabases(
              request: ListDatabasesRequest
          ): ZStream[Any, AwsError, String] =
            rts.unsafeRun(proxy(ListDatabases, request))
          def listDatabasesPaginated(request: ListDatabasesRequest): IO[
            AwsError,
            zio.aws.redshiftdata.model.ListDatabasesResponse.ReadOnly
          ] = proxy(ListDatabasesPaginated, request)
          def batchExecuteStatement(request: BatchExecuteStatementRequest): IO[
            AwsError,
            zio.aws.redshiftdata.model.BatchExecuteStatementResponse.ReadOnly
          ] = proxy(BatchExecuteStatement, request)
          def executeStatement(request: ExecuteStatementRequest): IO[
            AwsError,
            zio.aws.redshiftdata.model.ExecuteStatementResponse.ReadOnly
          ] = proxy(ExecuteStatement, request)
          def listStatements(request: ListStatementsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.redshiftdata.model.StatementData.ReadOnly
          ] = rts.unsafeRun(proxy(ListStatements, request))
          def listStatementsPaginated(request: ListStatementsRequest): IO[
            AwsError,
            zio.aws.redshiftdata.model.ListStatementsResponse.ReadOnly
          ] = proxy(ListStatementsPaginated, request)
          def listTables(request: ListTablesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.redshiftdata.model.TableMember.ReadOnly
          ] = rts.unsafeRun(proxy(ListTables, request))
          def listTablesPaginated(
              request: ListTablesRequest
          ): IO[AwsError, ReadOnly] = proxy(ListTablesPaginated, request)
          def describeTable(
              request: DescribeTableRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.redshiftdata.model.DescribeTableResponse.ReadOnly,
            zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly
          ]] = proxy(DescribeTable, request)
          def describeTablePaginated(request: DescribeTableRequest): IO[
            AwsError,
            zio.aws.redshiftdata.model.DescribeTableResponse.ReadOnly
          ] = proxy(DescribeTablePaginated, request)
          def cancelStatement(request: CancelStatementRequest): IO[
            AwsError,
            zio.aws.redshiftdata.model.CancelStatementResponse.ReadOnly
          ] = proxy(CancelStatement, request)
          def getStatementResult(
              request: GetStatementResultRequest
          ): ZStream[Any, AwsError, List[
            zio.aws.redshiftdata.model.Field.ReadOnly
          ]] = rts.unsafeRun(proxy(GetStatementResult, request))
          def getStatementResultPaginated(
              request: GetStatementResultRequest
          ): IO[
            AwsError,
            zio.aws.redshiftdata.model.GetStatementResultResponse.ReadOnly
          ] = proxy(GetStatementResultPaginated, request)
          def listSchemas(
              request: ListSchemasRequest
          ): ZStream[Any, AwsError, String] =
            rts.unsafeRun(proxy(ListSchemas, request))
          def listSchemasPaginated(request: ListSchemasRequest): IO[
            AwsError,
            zio.aws.redshiftdata.model.ListSchemasResponse.ReadOnly
          ] = proxy(ListSchemasPaginated, request)
          def describeStatement(request: DescribeStatementRequest): IO[
            AwsError,
            zio.aws.redshiftdata.model.DescribeStatementResponse.ReadOnly
          ] = proxy(DescribeStatement, request)
        }
      }
    }
    .toLayer
}
