package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{
  StatementString,
  StatementId,
  Timestamp
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SubStatementData(
    createdAt: Option[Timestamp] = None,
    duration: Option[Long] = None,
    error: Option[String] = None,
    hasResultSet: Option[Boolean] = None,
    id: StatementId,
    queryString: Option[StatementString] = None,
    redshiftQueryId: Option[Long] = None,
    resultRows: Option[Long] = None,
    resultSize: Option[Long] = None,
    status: Option[zio.aws.redshiftdata.model.StatementStatusString] = None,
    updatedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.SubStatementData = {
    import SubStatementData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.SubStatementData
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(duration.map(value => value: java.lang.Long))(_.duration)
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .optionallyWith(hasResultSet.map(value => value: java.lang.Boolean))(
        _.hasResultSet
      )
      .id(StatementId.unwrap(id): java.lang.String)
      .optionallyWith(
        queryString.map(value =>
          StatementString.unwrap(value): java.lang.String
        )
      )(_.queryString)
      .optionallyWith(redshiftQueryId.map(value => value: java.lang.Long))(
        _.redshiftQueryId
      )
      .optionallyWith(resultRows.map(value => value: java.lang.Long))(
        _.resultRows
      )
      .optionallyWith(resultSize.map(value => value: java.lang.Long))(
        _.resultSize
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.SubStatementData.ReadOnly =
    zio.aws.redshiftdata.model.SubStatementData.wrap(buildAwsValue())
}
object SubStatementData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.SubStatementData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.SubStatementData =
      zio.aws.redshiftdata.model.SubStatementData(
        createdAt.map(value => value),
        duration.map(value => value),
        error.map(value => value),
        hasResultSet.map(value => value),
        id,
        queryString.map(value => value),
        redshiftQueryId.map(value => value),
        resultRows.map(value => value),
        resultSize.map(value => value),
        status.map(value => value),
        updatedAt.map(value => value)
      )
    def createdAt: Option[Timestamp]
    def duration: Option[Long]
    def error: Option[String]
    def hasResultSet: Option[Boolean]
    def id: StatementId
    def queryString: Option[StatementString]
    def redshiftQueryId: Option[Long]
    def resultRows: Option[Long]
    def resultSize: Option[Long]
    def status: Option[zio.aws.redshiftdata.model.StatementStatusString]
    def updatedAt: Option[Timestamp]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDuration: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("duration", duration)
    def getError: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("error", error)
    def getHasResultSet: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hasResultSet", hasResultSet)
    def getId: ZIO[Any, Nothing, StatementId] = ZIO.succeed(id)
    def getQueryString: ZIO[Any, AwsError, StatementString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getRedshiftQueryId: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("redshiftQueryId", redshiftQueryId)
    def getResultRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("resultRows", resultRows)
    def getResultSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("resultSize", resultSize)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.redshiftdata.model.StatementStatusString] =
      AwsError.unwrapOptionField("status", status)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.SubStatementData
  ) extends zio.aws.redshiftdata.model.SubStatementData.ReadOnly {
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
    override val duration: Option[Long] =
      scala.Option(impl.duration()).map(value => value: Long)
    override val error: Option[String] =
      scala.Option(impl.error()).map(value => value: String)
    override val hasResultSet: Option[Boolean] =
      scala.Option(impl.hasResultSet()).map(value => value: Boolean)
    override val id: StatementId =
      zio.aws.redshiftdata.model.primitives.StatementId(impl.id())
    override val queryString: Option[StatementString] = scala
      .Option(impl.queryString())
      .map(value =>
        zio.aws.redshiftdata.model.primitives.StatementString(value)
      )
    override val redshiftQueryId: Option[Long] =
      scala.Option(impl.redshiftQueryId()).map(value => value: Long)
    override val resultRows: Option[Long] =
      scala.Option(impl.resultRows()).map(value => value: Long)
    override val resultSize: Option[Long] =
      scala.Option(impl.resultSize()).map(value => value: Long)
    override val status
        : Option[zio.aws.redshiftdata.model.StatementStatusString] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.redshiftdata.model.StatementStatusString.wrap(value)
      )
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.SubStatementData
  ): zio.aws.redshiftdata.model.SubStatementData.ReadOnly = new Wrapper(impl)
}
