package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTablesResponse(
    nextToken: Option[String] = None,
    tables: Option[Iterable[zio.aws.redshiftdata.model.TableMember]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse = {
    import ListTablesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        tables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tables)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.ListTablesResponse.ReadOnly =
    zio.aws.redshiftdata.model.ListTablesResponse.wrap(buildAwsValue())
}
object ListTablesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.ListTablesResponse =
      zio.aws.redshiftdata.model.ListTablesResponse(
        nextToken.map(value => value),
        tables.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def tables: Option[List[zio.aws.redshiftdata.model.TableMember.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTables: ZIO[Any, AwsError, List[
      zio.aws.redshiftdata.model.TableMember.ReadOnly
    ]] = AwsError.unwrapOptionField("tables", tables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse
  ) extends zio.aws.redshiftdata.model.ListTablesResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val tables
        : Option[List[zio.aws.redshiftdata.model.TableMember.ReadOnly]] = scala
      .Option(impl.tables())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftdata.model.TableMember.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse
  ): zio.aws.redshiftdata.model.ListTablesResponse.ReadOnly = new Wrapper(impl)
}
