package zio.aws.redshiftdata.model
import java.lang.Integer
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{SecretArn, PageSize, Location}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDatabasesRequest(
    clusterIdentifier: Option[Location] = None,
    database: String,
    dbUser: Option[String] = None,
    maxResults: Option[PageSize] = None,
    nextToken: Option[String] = None,
    secretArn: Option[SecretArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest = {
    import ListDatabasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest
      .builder()
      .optionallyWith(
        clusterIdentifier.map(value => Location.unwrap(value): java.lang.String)
      )(_.clusterIdentifier)
      .database(database: java.lang.String)
      .optionallyWith(dbUser.map(value => value: java.lang.String))(_.dbUser)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.ListDatabasesRequest.ReadOnly =
    zio.aws.redshiftdata.model.ListDatabasesRequest.wrap(buildAwsValue())
}
object ListDatabasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.ListDatabasesRequest =
      zio.aws.redshiftdata.model.ListDatabasesRequest(
        clusterIdentifier.map(value => value),
        database,
        dbUser.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        secretArn.map(value => value)
      )
    def clusterIdentifier: Option[Location]
    def database: String
    def dbUser: Option[String]
    def maxResults: Option[PageSize]
    def nextToken: Option[String]
    def secretArn: Option[SecretArn]
    def getClusterIdentifier: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getDatabase: ZIO[Any, Nothing, String] = ZIO.succeed(database)
    def getDbUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest
  ) extends zio.aws.redshiftdata.model.ListDatabasesRequest.ReadOnly {
    override val clusterIdentifier: Option[Location] = scala
      .Option(impl.clusterIdentifier())
      .map(value => zio.aws.redshiftdata.model.primitives.Location(value))
    override val database: String = impl.database(): String
    override val dbUser: Option[String] =
      scala.Option(impl.dbUser()).map(value => value: String)
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.redshiftdata.model.primitives.PageSize(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val secretArn: Option[SecretArn] = scala
      .Option(impl.secretArn())
      .map(value => zio.aws.redshiftdata.model.primitives.SecretArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest
  ): zio.aws.redshiftdata.model.ListDatabasesRequest.ReadOnly = new Wrapper(
    impl
  )
}
