package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.{
  SecretArn,
  StatementString,
  Timestamp,
  StatementId,
  StatementNameString
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StatementData(
    createdAt: Option[Timestamp] = None,
    id: StatementId,
    isBatchStatement: Option[Boolean] = None,
    queryParameters: Option[Iterable[zio.aws.redshiftdata.model.SqlParameter]] =
      None,
    queryString: Option[StatementString] = None,
    queryStrings: Option[Iterable[StatementString]] = None,
    secretArn: Option[SecretArn] = None,
    statementName: Option[StatementNameString] = None,
    status: Option[zio.aws.redshiftdata.model.StatusString] = None,
    updatedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.StatementData = {
    import StatementData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.StatementData
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .id(StatementId.unwrap(id): java.lang.String)
      .optionallyWith(isBatchStatement.map(value => value: java.lang.Boolean))(
        _.isBatchStatement
      )
      .optionallyWith(
        queryParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queryParameters)
      .optionallyWith(
        queryString.map(value =>
          StatementString.unwrap(value): java.lang.String
        )
      )(_.queryString)
      .optionallyWith(
        queryStrings.map(value =>
          value.map { item =>
            StatementString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queryStrings)
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .optionallyWith(
        statementName.map(value =>
          StatementNameString.unwrap(value): java.lang.String
        )
      )(_.statementName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.StatementData.ReadOnly =
    zio.aws.redshiftdata.model.StatementData.wrap(buildAwsValue())
}
object StatementData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.StatementData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.StatementData =
      zio.aws.redshiftdata.model.StatementData(
        createdAt.map(value => value),
        id,
        isBatchStatement.map(value => value),
        queryParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        queryString.map(value => value),
        queryStrings.map(value => value),
        secretArn.map(value => value),
        statementName.map(value => value),
        status.map(value => value),
        updatedAt.map(value => value)
      )
    def createdAt: Option[Timestamp]
    def id: StatementId
    def isBatchStatement: Option[Boolean]
    def queryParameters
        : Option[List[zio.aws.redshiftdata.model.SqlParameter.ReadOnly]]
    def queryString: Option[StatementString]
    def queryStrings: Option[List[StatementString]]
    def secretArn: Option[SecretArn]
    def statementName: Option[StatementNameString]
    def status: Option[zio.aws.redshiftdata.model.StatusString]
    def updatedAt: Option[Timestamp]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getId: ZIO[Any, Nothing, StatementId] = ZIO.succeed(id)
    def getIsBatchStatement: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isBatchStatement", isBatchStatement)
    def getQueryParameters: ZIO[Any, AwsError, List[
      zio.aws.redshiftdata.model.SqlParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("queryParameters", queryParameters)
    def getQueryString: ZIO[Any, AwsError, StatementString] =
      AwsError.unwrapOptionField("queryString", queryString)
    def getQueryStrings: ZIO[Any, AwsError, List[StatementString]] =
      AwsError.unwrapOptionField("queryStrings", queryStrings)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
    def getStatementName: ZIO[Any, AwsError, StatementNameString] =
      AwsError.unwrapOptionField("statementName", statementName)
    def getStatus: ZIO[Any, AwsError, zio.aws.redshiftdata.model.StatusString] =
      AwsError.unwrapOptionField("status", status)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.StatementData
  ) extends zio.aws.redshiftdata.model.StatementData.ReadOnly {
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
    override val id: StatementId =
      zio.aws.redshiftdata.model.primitives.StatementId(impl.id())
    override val isBatchStatement: Option[Boolean] =
      scala.Option(impl.isBatchStatement()).map(value => value: Boolean)
    override val queryParameters
        : Option[List[zio.aws.redshiftdata.model.SqlParameter.ReadOnly]] = scala
      .Option(impl.queryParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftdata.model.SqlParameter.wrap(item)
        }.toList
      )
    override val queryString: Option[StatementString] = scala
      .Option(impl.queryString())
      .map(value =>
        zio.aws.redshiftdata.model.primitives.StatementString(value)
      )
    override val queryStrings: Option[List[StatementString]] = scala
      .Option(impl.queryStrings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftdata.model.primitives.StatementString(item)
        }.toList
      )
    override val secretArn: Option[SecretArn] = scala
      .Option(impl.secretArn())
      .map(value => zio.aws.redshiftdata.model.primitives.SecretArn(value))
    override val statementName: Option[StatementNameString] = scala
      .Option(impl.statementName())
      .map(value =>
        zio.aws.redshiftdata.model.primitives.StatementNameString(value)
      )
    override val status: Option[zio.aws.redshiftdata.model.StatusString] = scala
      .Option(impl.status())
      .map(value => zio.aws.redshiftdata.model.StatusString.wrap(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.redshiftdata.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.StatementData
  ): zio.aws.redshiftdata.model.StatementData.ReadOnly = new Wrapper(impl)
}
