package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.redshiftdata.model.primitives.StatementId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeStatementRequest(id: StatementId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.DescribeStatementRequest = {
    import DescribeStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.DescribeStatementRequest
      .builder()
      .id(StatementId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.DescribeStatementRequest.ReadOnly =
    zio.aws.redshiftdata.model.DescribeStatementRequest.wrap(buildAwsValue())
}
object DescribeStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.DescribeStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.DescribeStatementRequest =
      zio.aws.redshiftdata.model.DescribeStatementRequest(id)
    def id: StatementId
    def getId: ZIO[Any, Nothing, StatementId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.DescribeStatementRequest
  ) extends zio.aws.redshiftdata.model.DescribeStatementRequest.ReadOnly {
    override val id: StatementId =
      zio.aws.redshiftdata.model.primitives.StatementId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.DescribeStatementRequest
  ): zio.aws.redshiftdata.model.DescribeStatementRequest.ReadOnly = new Wrapper(
    impl
  )
}
