package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetStatementResultResponse(
    columnMetadata: Option[
      Iterable[zio.aws.redshiftdata.model.ColumnMetadata]
    ] = None,
    nextToken: Option[String] = None,
    records: Iterable[Iterable[zio.aws.redshiftdata.model.Field]],
    totalNumRows: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse = {
    import GetStatementResultResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse
      .builder()
      .optionallyWith(
        columnMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columnMetadata)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .records(records.map { item =>
        item.map { item =>
          item.buildAwsValue()
        }.asJavaCollection
      }.asJavaCollection)
      .optionallyWith(totalNumRows.map(value => value: java.lang.Long))(
        _.totalNumRows
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftdata.model.GetStatementResultResponse.ReadOnly =
    zio.aws.redshiftdata.model.GetStatementResultResponse.wrap(buildAwsValue())
}
object GetStatementResultResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.GetStatementResultResponse =
      zio.aws.redshiftdata.model.GetStatementResultResponse(
        columnMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        records.map { item =>
          item.map { item =>
            item.asEditable
          }
        },
        totalNumRows.map(value => value)
      )
    def columnMetadata
        : Option[List[zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly]]
    def nextToken: Option[String]
    def records: List[List[zio.aws.redshiftdata.model.Field.ReadOnly]]
    def totalNumRows: Option[Long]
    def getColumnMetadata: ZIO[Any, AwsError, List[
      zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("columnMetadata", columnMetadata)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecords: ZIO[Any, Nothing, List[
      List[zio.aws.redshiftdata.model.Field.ReadOnly]
    ]] = ZIO.succeed(records)
    def getTotalNumRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalNumRows", totalNumRows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse
  ) extends zio.aws.redshiftdata.model.GetStatementResultResponse.ReadOnly {
    override val columnMetadata
        : Option[List[zio.aws.redshiftdata.model.ColumnMetadata.ReadOnly]] =
      scala
        .Option(impl.columnMetadata())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftdata.model.ColumnMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val records
        : List[List[zio.aws.redshiftdata.model.Field.ReadOnly]] = impl
      .records()
      .asScala
      .map { item =>
        item.asScala.map { item =>
          zio.aws.redshiftdata.model.Field.wrap(item)
        }.toList
      }
      .toList
    override val totalNumRows: Option[Long] =
      scala.Option(impl.totalNumRows()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse
  ): zio.aws.redshiftdata.model.GetStatementResultResponse.ReadOnly =
    new Wrapper(impl)
}
