package zio.aws.redshiftdata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSchemasResponse(
    nextToken: Option[String] = None,
    schemas: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse = {
    import ListSchemasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        schemas.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.schemas)
      .build()
  }
  def asReadOnly: zio.aws.redshiftdata.model.ListSchemasResponse.ReadOnly =
    zio.aws.redshiftdata.model.ListSchemasResponse.wrap(buildAwsValue())
}
object ListSchemasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftdata.model.ListSchemasResponse =
      zio.aws.redshiftdata.model.ListSchemasResponse(
        nextToken.map(value => value),
        schemas.map(value => value)
      )
    def nextToken: Option[String]
    def schemas: Option[List[String]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSchemas: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("schemas", schemas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse
  ) extends zio.aws.redshiftdata.model.ListSchemasResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val schemas: Option[List[String]] = scala
      .Option(impl.schemas())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse
  ): zio.aws.redshiftdata.model.ListSchemasResponse.ReadOnly = new Wrapper(impl)
}
