package zio.aws.redshift.model
import scala.jdk.CollectionConverters.*
sealed trait ZeroETLIntegrationStatus {
  def unwrap
      : software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus
}
object ZeroETLIntegrationStatus {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus
  ): zio.aws.redshift.model.ZeroETLIntegrationStatus = value match {
    case software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.CREATING =>
      val r = creating
      r
    case software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.MODIFYING =>
      val r = modifying
      r
    case software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.SYNCING =>
      val r = syncing
      r
    case software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.NEEDS_ATTENTION =>
      val r = needs_attention
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.ZeroETLIntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus =
      software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object creating extends zio.aws.redshift.model.ZeroETLIntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus =
      software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.CREATING
  }
  case object active extends zio.aws.redshift.model.ZeroETLIntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus =
      software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.ACTIVE
  }
  case object modifying
      extends zio.aws.redshift.model.ZeroETLIntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus =
      software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.MODIFYING
  }
  case object failed extends zio.aws.redshift.model.ZeroETLIntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus =
      software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.FAILED
  }
  case object deleting extends zio.aws.redshift.model.ZeroETLIntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus =
      software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.DELETING
  }
  case object syncing extends zio.aws.redshift.model.ZeroETLIntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus =
      software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.SYNCING
  }
  case object needs_attention
      extends zio.aws.redshift.model.ZeroETLIntegrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus =
      software.amazon.awssdk.services.redshift.model.ZeroETLIntegrationStatus.NEEDS_ATTENTION
  }
}
